/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.boot.config;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springblade.core.boot.context.BladeRunnableWrapper;
import org.springblade.core.boot.props.BladeAsyncProperties;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.aop.interceptor.SimpleAsyncUncaughtExceptionHandler;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
@EnableScheduling
@EnableConfigurationProperties(value={BladeAsyncProperties.class})
public class BladeExecutorConfiguration
extends AsyncConfigurerSupport {
    private final BladeAsyncProperties bladeAsyncProperties;

    @Bean(name={"taskExecutor"})
    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.bladeAsyncProperties.getCorePoolSize());
        executor.setMaxPoolSize(this.bladeAsyncProperties.getMaxPoolSize());
        executor.setQueueCapacity(this.bladeAsyncProperties.getQueueCapacity());
        executor.setKeepAliveSeconds(this.bladeAsyncProperties.getKeepAliveSeconds());
        executor.setThreadNamePrefix("async-executor-");
        executor.setTaskDecorator(BladeRunnableWrapper::new);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new SimpleAsyncUncaughtExceptionHandler();
    }

    public BladeExecutorConfiguration(BladeAsyncProperties bladeAsyncProperties) {
        this.bladeAsyncProperties = bladeAsyncProperties;
    }
}

