/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.boot.config;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.boot.props.BladeFileProperties;
import org.springblade.core.boot.props.BladeUploadProperties;
import org.springblade.core.boot.resolver.TokenArgumentResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Order(value=-2147483648)
@EnableConfigurationProperties(value={BladeUploadProperties.class, BladeFileProperties.class})
public class BladeWebMvcConfiguration
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(BladeWebMvcConfiguration.class);
    private final BladeUploadProperties bladeUploadProperties;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String path = this.bladeUploadProperties.getSavePath();
        registry.addResourceHandler(new String[]{"/upload/**"}).addResourceLocations(new String[]{"file:" + path + "/upload/"});
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(new TokenArgumentResolver());
    }

    public BladeWebMvcConfiguration(BladeUploadProperties bladeUploadProperties) {
        this.bladeUploadProperties = bladeUploadProperties;
    }
}

