/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.boot.context;

import java.util.Map;
import org.slf4j.MDC;
import org.springblade.core.tool.utils.ThreadLocalUtil;
import org.springframework.lang.Nullable;

public class BladeRunnableWrapper
implements Runnable {
    private final Runnable delegate;
    private final Map<String, Object> tlMap;
    @Nullable
    private final Map<String, String> mdcMap;

    public BladeRunnableWrapper(Runnable runnable) {
        this.delegate = runnable;
        this.tlMap = ThreadLocalUtil.getAll();
        this.mdcMap = MDC.getCopyOfContextMap();
    }

    @Override
    public void run() {
        if (!this.tlMap.isEmpty()) {
            ThreadLocalUtil.put(this.tlMap);
        }
        if (this.mdcMap != null && !this.mdcMap.isEmpty()) {
            MDC.setContextMap(this.mdcMap);
        }
        try {
            this.delegate.run();
        }
        finally {
            this.tlMap.clear();
            if (this.mdcMap != null) {
                this.mdcMap.clear();
            }
            ThreadLocalUtil.clear();
            MDC.clear();
        }
    }
}

