/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.boot.ctrl;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springblade.core.boot.file.BladeFileUtil;
import org.springblade.core.boot.file.LocalFile;
import org.springblade.core.secure.BladeUser;
import org.springblade.core.secure.utils.AuthUtil;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.utils.Charsets;
import org.springblade.core.tool.utils.WebUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourceRegion;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriUtils;

public class BladeController {
    @Autowired
    private HttpServletRequest request;

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public BladeUser getUser() {
        return AuthUtil.getUser();
    }

    public <T> R<T> data(T data) {
        return R.data(data);
    }

    public <T> R<T> data(T data, String message) {
        return R.data(data, (String)message);
    }

    public <T> R<T> data(T data, String message, int code) {
        return R.data((int)code, data, (String)message);
    }

    public R success(String message) {
        return R.success((String)message);
    }

    public R fail(String message) {
        return R.fail((String)message);
    }

    public R status(boolean flag) {
        return R.status((boolean)flag);
    }

    public LocalFile getFile(MultipartFile file) {
        return BladeFileUtil.getFile(file);
    }

    public LocalFile getFile(MultipartFile file, String dir) {
        return BladeFileUtil.getFile(file, dir);
    }

    public LocalFile getFile(MultipartFile file, String dir, String path, String virtualPath) {
        return BladeFileUtil.getFile(file, dir, path, virtualPath);
    }

    public List<LocalFile> getFiles(List<MultipartFile> files) {
        return BladeFileUtil.getFiles(files);
    }

    public List<LocalFile> getFiles(List<MultipartFile> files, String dir) {
        return BladeFileUtil.getFiles(files, dir);
    }

    public List<LocalFile> getFiles(List<MultipartFile> files, String dir, String path, String virtualPath) {
        return BladeFileUtil.getFiles(files, dir, path, virtualPath);
    }

    protected ResponseEntity<ResourceRegion> download(File file) throws IOException {
        String fileName = file.getName();
        return this.download(file, fileName);
    }

    protected ResponseEntity<ResourceRegion> download(File file, String fileName) throws IOException {
        FileSystemResource resource = new FileSystemResource(file);
        return this.download((Resource)resource, fileName);
    }

    protected ResponseEntity<ResourceRegion> download(Resource resource, String fileName) throws IOException {
        HttpServletRequest request = WebUtil.getRequest();
        String header = request.getHeader("User-Agent");
        header = header == null ? "" : header.toUpperCase();
        String msie = "MSIE";
        String trident = "TRIDENT";
        String edge = "EDGE";
        HttpStatus status = header.contains(msie) || header.contains(trident) || header.contains(edge) ? HttpStatus.OK : HttpStatus.CREATED;
        long position = 0L;
        long count = resource.contentLength();
        String range = request.getHeader("Range");
        if (null != range) {
            status = HttpStatus.PARTIAL_CONTENT;
            String[] rangeRange = range.replace("bytes=", "").split("-");
            position = Long.parseLong(rangeRange[0]);
            if (rangeRange.length > 1) {
                long end = Long.parseLong(rangeRange[1]);
                count = end - position + 1L;
            }
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        String encodeFileName = UriUtils.encode((String)fileName, (Charset)Charsets.UTF_8);
        String disposition = "attachment;filename=\"" + encodeFileName + "\";filename*=utf-8''" + encodeFileName;
        headers.set("Content-Disposition", disposition);
        return new ResponseEntity((Object)new ResourceRegion(resource, position, count), (MultiValueMap)headers, status);
    }
}

