/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.boot.file;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import org.springblade.core.boot.file.BladeFileUtil;
import org.springblade.core.boot.file.IFileProxy;
import org.springblade.core.boot.props.BladeFileProperties;
import org.springblade.core.tool.utils.DateUtil;
import org.springblade.core.tool.utils.ImageUtil;
import org.springblade.core.tool.utils.SpringUtil;

public class LocalFileProxyFactory
implements IFileProxy {
    private static BladeFileProperties fileProperties;

    private static BladeFileProperties getBladeFileProperties() {
        if (fileProperties == null) {
            fileProperties = (BladeFileProperties)SpringUtil.getBean(BladeFileProperties.class);
        }
        return fileProperties;
    }

    @Override
    public File rename(File f, String path) {
        File dest = new File(path);
        f.renameTo(dest);
        return dest;
    }

    @Override
    public String[] path(File f, String dir) {
        long time = System.nanoTime();
        StringBuilder uploadPath = new StringBuilder().append(LocalFileProxyFactory.getFileDir(dir, LocalFileProxyFactory.getBladeFileProperties().getUploadRealPath())).append(time).append(LocalFileProxyFactory.getFileExt(f.getName()));
        StringBuilder virtualPath = new StringBuilder().append(LocalFileProxyFactory.getFileDir(dir, LocalFileProxyFactory.getBladeFileProperties().getUploadCtxPath())).append(time).append(LocalFileProxyFactory.getFileExt(f.getName()));
        return new String[]{BladeFileUtil.formatUrl(uploadPath.toString()), BladeFileUtil.formatUrl(virtualPath.toString())};
    }

    public static String getFileExt(String fileName) {
        if (!fileName.contains(".")) {
            return ".jpg";
        }
        return fileName.substring(fileName.lastIndexOf("."));
    }

    public static String getFileDir(String dir, String saveDir) {
        StringBuilder newFileDir = new StringBuilder();
        newFileDir.append(saveDir).append(File.separator).append(dir).append(File.separator).append(DateUtil.format((Date)DateUtil.now(), (String)"yyyyMMdd")).append(File.separator);
        return newFileDir.toString();
    }

    @Override
    public void compress(String path) {
        try {
            ImageUtil.zoomScale((BufferedImage)ImageUtil.readImage((String)path), (OutputStream)new FileOutputStream(new File(path)), null, (double)LocalFileProxyFactory.getBladeFileProperties().getCompressScale(), (boolean)LocalFileProxyFactory.getBladeFileProperties().getCompressFlag());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

