/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.boot.config;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.boot.error.ErrorType;
import org.springblade.core.boot.error.ErrorUtil;
import org.springblade.core.context.BladeContext;
import org.springblade.core.context.BladeRunnableWrapper;
import org.springblade.core.launch.props.BladeProperties;
import org.springblade.core.log.event.ErrorLogEvent;
import org.springblade.core.log.model.LogError;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.boot.task.TaskExecutorCustomizer;
import org.springframework.boot.task.TaskSchedulerCustomizer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.util.ErrorHandler;

@Configuration
@EnableAsync
@EnableScheduling
public class BladeExecutorConfiguration
extends AsyncConfigurerSupport {
    private static final Logger log = LoggerFactory.getLogger(BladeExecutorConfiguration.class);
    private final BladeContext bladeContext;
    private final BladeProperties bladeProperties;
    private final ApplicationEventPublisher publisher;

    @Bean
    public TaskExecutorCustomizer taskExecutorCustomizer() {
        return taskExecutor -> {
            taskExecutor.setThreadNamePrefix("async-task-");
            taskExecutor.setTaskDecorator(BladeRunnableWrapper::new);
            taskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        };
    }

    @Bean
    public TaskSchedulerCustomizer taskSchedulerCustomizer() {
        return taskExecutor -> {
            taskExecutor.setThreadNamePrefix("async-scheduler");
            taskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
            taskExecutor.setErrorHandler((ErrorHandler)new BladeErrorHandler(this.bladeContext, this.bladeProperties, this.publisher));
        };
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new BladeAsyncUncaughtExceptionHandler(this.bladeContext, this.bladeProperties, this.publisher);
    }

    public BladeExecutorConfiguration(BladeContext bladeContext, BladeProperties bladeProperties, ApplicationEventPublisher publisher) {
        this.bladeContext = bladeContext;
        this.bladeProperties = bladeProperties;
        this.publisher = publisher;
    }

    private static class BladeErrorHandler
    implements ErrorHandler {
        private final BladeContext bladeContext;
        private final BladeProperties bladeProperties;
        private final ApplicationEventPublisher eventPublisher;

        public void handleError(@NonNull Throwable error) {
            log.error("Unexpected scheduler exception", error);
            LogError logError = new LogError();
            logError.setParams(ErrorType.SCHEDULER.getType());
            logError.setServiceId(this.bladeProperties.getName());
            logError.setEnv(this.bladeProperties.getEnv());
            logError.setRequestUri(this.bladeContext.getRequestId());
            ErrorUtil.initErrorInfo(error, logError);
            HashMap<String, LogError> event = new HashMap<String, LogError>(16);
            event.put("log", logError);
            this.eventPublisher.publishEvent((ApplicationEvent)new ErrorLogEvent(event));
        }

        public BladeErrorHandler(BladeContext bladeContext, BladeProperties bladeProperties, ApplicationEventPublisher eventPublisher) {
            this.bladeContext = bladeContext;
            this.bladeProperties = bladeProperties;
            this.eventPublisher = eventPublisher;
        }
    }

    private static class BladeAsyncUncaughtExceptionHandler
    implements AsyncUncaughtExceptionHandler {
        private final BladeContext bladeContext;
        private final BladeProperties bladeProperties;
        private final ApplicationEventPublisher eventPublisher;

        public void handleUncaughtException(@NonNull Throwable error, @NonNull Method method, Object ... params) {
            log.error("Unexpected exception occurred invoking async method: {}", (Object)method, (Object)error);
            LogError logError = new LogError();
            logError.setParams(ErrorType.ASYNC.getType());
            logError.setEnv(this.bladeProperties.getEnv());
            logError.setServiceId(this.bladeProperties.getName());
            logError.setRequestUri(this.bladeContext.getRequestId());
            ErrorUtil.initErrorInfo(error, logError);
            HashMap<String, LogError> event = new HashMap<String, LogError>(16);
            event.put("log", logError);
            this.eventPublisher.publishEvent((ApplicationEvent)new ErrorLogEvent(event));
        }

        public BladeAsyncUncaughtExceptionHandler(BladeContext bladeContext, BladeProperties bladeProperties, ApplicationEventPublisher eventPublisher) {
            this.bladeContext = bladeContext;
            this.bladeProperties = bladeProperties;
            this.eventPublisher = eventPublisher;
        }
    }
}

