/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.boot.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.retry.interceptor.RetryInterceptorBuilder;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;

@Configuration
public class BladeRetryConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BladeRetryConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(name={"configServerRetryInterceptor"})
    public RetryOperationsInterceptor configServerRetryInterceptor() {
        log.info(String.format("configServerRetryInterceptor: Changing backOffOptions to initial: %s, multiplier: %s, maxInterval: %s", 1000, 1.2, 5000));
        return (RetryOperationsInterceptor)RetryInterceptorBuilder.stateless().backOffOptions(1000L, 1.2, 5000L).maxAttempts(10).build();
    }
}

