/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.boot.config;

import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springblade.core.boot.request.BladeRequestFilter;
import org.springblade.core.boot.request.XssProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={XssProperties.class})
public class RequestConfiguration {
    private final XssProperties xssProperties;

    @Bean
    public FilterRegistrationBean<BladeRequestFilter> bladeFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        registration.setFilter((Filter)new BladeRequestFilter(this.xssProperties));
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("bladeRequestFilter");
        registration.setOrder(Integer.MAX_VALUE);
        return registration;
    }

    public RequestConfiguration(XssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }
}

