/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.boot.file;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.springblade.core.boot.file.BladeFileUtil;
import org.springblade.core.boot.file.FileProxyManager;
import org.springblade.core.boot.file.IFileProxy;
import org.springblade.core.boot.props.BladeFileProperties;
import org.springblade.core.tool.utils.DateUtil;
import org.springblade.core.tool.utils.SpringUtil;
import org.springframework.web.multipart.MultipartFile;

public class LocalFile {
    private Object fileId;
    @JsonIgnore
    private MultipartFile file;
    private String dir;
    private String uploadPath;
    private String uploadVirtualPath;
    private String fileName;
    private String originalFileName;
    private static BladeFileProperties fileProperties;

    private static BladeFileProperties getBladeFileProperties() {
        if (fileProperties == null) {
            fileProperties = (BladeFileProperties)SpringUtil.getBean(BladeFileProperties.class);
        }
        return fileProperties;
    }

    public LocalFile(MultipartFile file, String dir) {
        this.dir = dir;
        this.file = file;
        this.fileName = file.getName();
        this.originalFileName = file.getOriginalFilename();
        this.uploadPath = BladeFileUtil.formatUrl(File.separator + LocalFile.getBladeFileProperties().getUploadRealPath() + File.separator + dir + File.separator + DateUtil.format((Date)DateUtil.now(), (String)"yyyyMMdd") + File.separator + this.originalFileName);
        this.uploadVirtualPath = BladeFileUtil.formatUrl(LocalFile.getBladeFileProperties().getUploadCtxPath().replace(LocalFile.getBladeFileProperties().getContextPath(), "") + File.separator + dir + File.separator + DateUtil.format((Date)DateUtil.now(), (String)"yyyyMMdd") + File.separator + this.originalFileName);
    }

    public LocalFile(MultipartFile file, String dir, String uploadPath, String uploadVirtualPath) {
        this(file, dir);
        if (null != uploadPath) {
            this.uploadPath = BladeFileUtil.formatUrl(uploadPath);
            this.uploadVirtualPath = BladeFileUtil.formatUrl(uploadVirtualPath);
        }
    }

    public void transfer() {
        this.transfer(LocalFile.getBladeFileProperties().getCompress());
    }

    public void transfer(boolean compress) {
        IFileProxy fileFactory = FileProxyManager.me().getDefaultFileProxyFactory();
        this.transfer(fileFactory, compress);
    }

    public void transfer(IFileProxy fileFactory, boolean compress) {
        try {
            File pfile;
            File file = new File(this.uploadPath);
            if (null != fileFactory) {
                String[] path = fileFactory.path(file, this.dir);
                this.uploadPath = path[0];
                this.uploadVirtualPath = path[1];
                file = fileFactory.rename(file, path[0]);
            }
            if (!(pfile = file.getParentFile()).exists()) {
                pfile.mkdirs();
            }
            this.file.transferTo(file);
            if (compress) {
                fileFactory.compress(this.uploadPath);
            }
        }
        catch (IOException | IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public Object getFileId() {
        return this.fileId;
    }

    public MultipartFile getFile() {
        return this.file;
    }

    public String getDir() {
        return this.dir;
    }

    public String getUploadPath() {
        return this.uploadPath;
    }

    public String getUploadVirtualPath() {
        return this.uploadVirtualPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public void setFileId(Object fileId) {
        this.fileId = fileId;
    }

    @JsonIgnore
    public void setFile(MultipartFile file) {
        this.file = file;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setUploadPath(String uploadPath) {
        this.uploadPath = uploadPath;
    }

    public void setUploadVirtualPath(String uploadVirtualPath) {
        this.uploadVirtualPath = uploadVirtualPath;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setOriginalFileName(String originalFileName) {
        this.originalFileName = originalFileName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalFile)) {
            return false;
        }
        LocalFile other = (LocalFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$fileId = this.getFileId();
        Object other$fileId = other.getFileId();
        if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
            return false;
        }
        MultipartFile this$file = this.getFile();
        MultipartFile other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        String this$dir = this.getDir();
        String other$dir = other.getDir();
        if (this$dir == null ? other$dir != null : !this$dir.equals(other$dir)) {
            return false;
        }
        String this$uploadPath = this.getUploadPath();
        String other$uploadPath = other.getUploadPath();
        if (this$uploadPath == null ? other$uploadPath != null : !this$uploadPath.equals(other$uploadPath)) {
            return false;
        }
        String this$uploadVirtualPath = this.getUploadVirtualPath();
        String other$uploadVirtualPath = other.getUploadVirtualPath();
        if (this$uploadVirtualPath == null ? other$uploadVirtualPath != null : !this$uploadVirtualPath.equals(other$uploadVirtualPath)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$originalFileName = this.getOriginalFileName();
        String other$originalFileName = other.getOriginalFileName();
        return !(this$originalFileName == null ? other$originalFileName != null : !this$originalFileName.equals(other$originalFileName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocalFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $fileId = this.getFileId();
        result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
        MultipartFile $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        String $dir = this.getDir();
        result = result * 59 + ($dir == null ? 43 : $dir.hashCode());
        String $uploadPath = this.getUploadPath();
        result = result * 59 + ($uploadPath == null ? 43 : $uploadPath.hashCode());
        String $uploadVirtualPath = this.getUploadVirtualPath();
        result = result * 59 + ($uploadVirtualPath == null ? 43 : $uploadVirtualPath.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $originalFileName = this.getOriginalFileName();
        result = result * 59 + ($originalFileName == null ? 43 : $originalFileName.hashCode());
        return result;
    }

    public String toString() {
        return "LocalFile(fileId=" + this.getFileId() + ", file=" + this.getFile() + ", dir=" + this.getDir() + ", uploadPath=" + this.getUploadPath() + ", uploadVirtualPath=" + this.getUploadVirtualPath() + ", fileName=" + this.getFileName() + ", originalFileName=" + this.getOriginalFileName() + ")";
    }
}

