/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.boot.request;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springblade.core.boot.request.BladeHttpServletRequestWrapper;
import org.springblade.core.boot.request.XssHttpServletRequestWrapper;
import org.springblade.core.boot.request.XssProperties;

public class BladeRequestFilter
implements Filter {
    private final XssProperties xssProperties;

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String path = ((HttpServletRequest)request).getServletPath();
        if (!this.xssProperties.getEnabled().booleanValue() || this.isSkip(path)) {
            BladeHttpServletRequestWrapper bladeRequest = new BladeHttpServletRequestWrapper((HttpServletRequest)request);
            chain.doFilter((ServletRequest)bladeRequest, response);
        } else {
            XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request);
            chain.doFilter((ServletRequest)xssRequest, response);
        }
    }

    private boolean isSkip(String path) {
        return this.xssProperties.getSkipUrl().stream().map(url -> url.replace("/**", "")).anyMatch(path::startsWith);
    }

    public void destroy() {
    }

    public BladeRequestFilter(XssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }
}

