/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.cloud.feign;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class BladeFeignRequestHeaderInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BladeFeignRequestHeaderInterceptor.class);

    public void apply(RequestTemplate requestTemplate) {
        HttpServletRequest request;
        Enumeration headerNames;
        ServletRequestAttributes attrs = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attrs != null && (headerNames = (request = attrs.getRequest()).getHeaderNames()) != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                String value = request.getHeader(name);
                if (!"blade-auth".equals(name)) continue;
                requestTemplate.header(name, new String[]{value});
            }
        }
    }
}

