/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.cloud.feign;

import feign.Target;
import feign.hystrix.FallbackFactory;
import org.springblade.core.cloud.feign.BladeFeignFallback;
import org.springframework.cglib.proxy.Enhancer;

public class BladeFallbackFactory<T>
implements FallbackFactory<T> {
    private final Target<T> target;

    public T create(Throwable cause) {
        Class targetType = this.target.type();
        String targetName = this.target.name();
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(targetType);
        enhancer.setUseCache(true);
        enhancer.setCallback(new BladeFeignFallback(targetType, targetName, cause));
        return (T)enhancer.create();
    }

    public BladeFallbackFactory(Target<T> target) {
        this.target = target;
    }
}

