/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.cloud.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springblade.core.cloud.http.HttpLoggingInterceptor;
import org.springblade.core.cloud.http.LbRestTemplate;
import org.springblade.core.cloud.http.OkHttpSlf4jLogger;
import org.springblade.core.cloud.http.RestTemplateHeaderInterceptor;
import org.springblade.core.cloud.hystrix.BladeHystrixAccountGetter;
import org.springblade.core.cloud.props.BladeHystrixHeadersProperties;
import org.springblade.core.tool.utils.Charsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.commons.httpclient.OkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientFactory;
import org.springframework.cloud.openfeign.support.FeignHttpClientProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(value={OkHttpClient.class})
public class RestTemplateConfiguration {
    private final ObjectMapper objectMapper;

    @Bean(value={"httpLoggingInterceptor"})
    @Profile(value={"dev", "test"})
    public HttpLoggingInterceptor testLoggingInterceptor() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor(new OkHttpSlf4jLogger());
        interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        return interceptor;
    }

    @Bean(value={"httpLoggingInterceptor"})
    @Profile(value={"ontest"})
    public HttpLoggingInterceptor onTestLoggingInterceptor() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor(new OkHttpSlf4jLogger());
        interceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
        return interceptor;
    }

    @Bean(value={"httpLoggingInterceptor"})
    @Profile(value={"prod"})
    public HttpLoggingInterceptor prodLoggingInterceptor() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor(new OkHttpSlf4jLogger());
        interceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
        return interceptor;
    }

    @Bean
    @ConditionalOnMissingBean(value={ConnectionPool.class})
    public ConnectionPool httpClientConnectionPool(FeignHttpClientProperties httpClientProperties, OkHttpClientConnectionPoolFactory connectionPoolFactory) {
        Integer maxTotalConnections = httpClientProperties.getMaxConnections();
        Long timeToLive = httpClientProperties.getTimeToLive();
        TimeUnit ttlUnit = httpClientProperties.getTimeToLiveUnit();
        return connectionPoolFactory.create(maxTotalConnections.intValue(), timeToLive.longValue(), ttlUnit);
    }

    @Bean
    @ConditionalOnMissingBean(value={OkHttpClient.class})
    public OkHttpClient httpClient(OkHttpClientFactory httpClientFactory, ConnectionPool connectionPool, FeignHttpClientProperties httpClientProperties, HttpLoggingInterceptor interceptor) {
        Boolean followRedirects = httpClientProperties.isFollowRedirects();
        Integer connectTimeout = httpClientProperties.getConnectionTimeout();
        return httpClientFactory.createBuilder(httpClientProperties.isDisableSslValidation()).connectTimeout((long)connectTimeout.intValue(), TimeUnit.MILLISECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).followRedirects(followRedirects.booleanValue()).connectionPool(connectionPool).addInterceptor((Interceptor)interceptor).build();
    }

    @Bean
    public RestTemplateHeaderInterceptor requestHeaderInterceptor(@Autowired(required=false) @Nullable BladeHystrixAccountGetter accountGetter, BladeHystrixHeadersProperties properties) {
        return new RestTemplateHeaderInterceptor(accountGetter, properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={RestTemplate.class})
    public RestTemplate restTemplate(OkHttpClient httpClient) {
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new OkHttp3ClientHttpRequestFactory(httpClient));
        this.configMessageConverters(restTemplate.getMessageConverters());
        return restTemplate;
    }

    @Bean
    @LoadBalanced
    @ConditionalOnMissingBean(value={LbRestTemplate.class})
    public LbRestTemplate lbRestTemplate(OkHttpClient httpClient, RestTemplateHeaderInterceptor interceptor) {
        LbRestTemplate lbRestTemplate = new LbRestTemplate((ClientHttpRequestFactory)new OkHttp3ClientHttpRequestFactory(httpClient));
        lbRestTemplate.setInterceptors(Collections.singletonList(interceptor));
        this.configMessageConverters(lbRestTemplate.getMessageConverters());
        return lbRestTemplate;
    }

    private void configMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.removeIf(x -> x instanceof StringHttpMessageConverter || x instanceof MappingJackson2HttpMessageConverter);
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter(Charsets.UTF_8));
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(this.objectMapper));
    }

    public RestTemplateConfiguration(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

