/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.cloud.http;

import java.io.IOException;
import org.springblade.core.cloud.hystrix.BladeHttpHeadersContextHolder;
import org.springblade.core.cloud.hystrix.BladeHystrixAccountGetter;
import org.springblade.core.cloud.props.BladeHystrixHeadersProperties;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;

public class RestTemplateHeaderInterceptor
implements ClientHttpRequestInterceptor {
    @Nullable
    private final BladeHystrixAccountGetter accountGetter;
    private final BladeHystrixHeadersProperties properties;

    public ClientHttpResponse intercept(HttpRequest request, byte[] bytes, ClientHttpRequestExecution execution) throws IOException {
        HttpHeaders headers = BladeHttpHeadersContextHolder.get();
        if (headers == null) {
            headers = BladeHttpHeadersContextHolder.toHeaders(this.accountGetter, this.properties);
        }
        if (headers != null && !headers.isEmpty()) {
            HttpHeaders httpHeaders = request.getHeaders();
            headers.forEach((key, values) -> values.forEach(value -> httpHeaders.add(key, value)));
        }
        return execution.execute(request, bytes);
    }

    public RestTemplateHeaderInterceptor(@Nullable BladeHystrixAccountGetter accountGetter, BladeHystrixHeadersProperties properties) {
        this.accountGetter = accountGetter;
        this.properties = properties;
    }
}

