/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.cloud.hystrix;

import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.MDC;
import org.springblade.core.cloud.hystrix.BladeHttpHeadersContextHolder;
import org.springblade.core.cloud.hystrix.BladeHystrixAccountGetter;
import org.springblade.core.cloud.props.BladeHystrixHeadersProperties;
import org.springblade.core.tool.utils.ThreadLocalUtil;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;

public class BladeHttpHeadersCallable<V>
implements Callable<V> {
    private final Callable<V> delegate;
    private final Map<String, Object> tlMap;
    @Nullable
    private final Map<String, String> mdcMap;
    @Nullable
    private HttpHeaders httpHeaders;

    public BladeHttpHeadersCallable(Callable<V> delegate, @Nullable BladeHystrixAccountGetter accountGetter, BladeHystrixHeadersProperties properties) {
        this.delegate = delegate;
        this.tlMap = ThreadLocalUtil.getAll();
        this.mdcMap = MDC.getCopyOfContextMap();
        this.httpHeaders = BladeHttpHeadersContextHolder.toHeaders(accountGetter, properties);
    }

    @Override
    public V call() throws Exception {
        try {
            if (!this.tlMap.isEmpty()) {
                ThreadLocalUtil.put(this.tlMap);
            }
            if (this.mdcMap != null && !this.mdcMap.isEmpty()) {
                MDC.setContextMap(this.mdcMap);
            }
            BladeHttpHeadersContextHolder.set(this.httpHeaders);
            V v = this.delegate.call();
            return v;
        }
        finally {
            this.tlMap.clear();
            if (this.mdcMap != null) {
                this.mdcMap.clear();
            }
            ThreadLocalUtil.clear();
            MDC.clear();
            BladeHttpHeadersContextHolder.remove();
            if (this.httpHeaders != null) {
                this.httpHeaders.clear();
            }
            this.httpHeaders = null;
        }
    }
}

