/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.cloud.hystrix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springblade.core.cloud.hystrix.BladeHystrixAccountGetter;
import org.springblade.core.cloud.props.BladeHystrixHeadersProperties;
import org.springblade.core.tool.utils.StringUtil;
import org.springblade.core.tool.utils.WebUtil;
import org.springframework.core.NamedThreadLocal;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.PatternMatchUtils;

public class BladeHttpHeadersContextHolder {
    private static final ThreadLocal<HttpHeaders> HTTP_HEADERS_HOLDER = new NamedThreadLocal("Blade hystrix HttpHeaders");
    private static final String[] ALLOW_HEADS = new String[]{"X-Real-IP", "x-forwarded-for", "authorization", "Blade-Auth".toLowerCase(), "Authorization", "Blade-Auth"};

    static void set(HttpHeaders httpHeaders) {
        HTTP_HEADERS_HOLDER.set(httpHeaders);
    }

    @Nullable
    public static HttpHeaders get() {
        return HTTP_HEADERS_HOLDER.get();
    }

    static void remove() {
        HTTP_HEADERS_HOLDER.remove();
    }

    @Nullable
    public static HttpHeaders toHeaders(@Nullable BladeHystrixAccountGetter accountGetter, BladeHystrixHeadersProperties properties) {
        String xAccountHeader;
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        String accountHeaderName = properties.getAccount();
        if (accountGetter != null && StringUtil.isNotBlank((CharSequence)(xAccountHeader = accountGetter.get(request)))) {
            headers.add(accountHeaderName, xAccountHeader);
        }
        ArrayList<String> allowHeadsList = new ArrayList<String>(Arrays.asList(ALLOW_HEADS));
        allowHeadsList.add(accountHeaderName);
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            List<String> allowed = properties.getAllowed();
            String pattern = properties.getPattern();
            while (headerNames.hasMoreElements()) {
                String values;
                String key = (String)headerNames.nextElement();
                if (!allowHeadsList.contains(key) && !allowed.contains(key) && !PatternMatchUtils.simpleMatch((String)pattern, (String)key) || !StringUtil.isNotBlank((CharSequence)(values = request.getHeader(key)))) continue;
                headers.add(key, values);
            }
        }
        return headers.isEmpty() ? null : headers;
    }
}

