/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.cloud.feign;

import com.netflix.hystrix.HystrixCommand;
import feign.Contract;
import feign.Feign;
import feign.RequestInterceptor;
import feign.hystrix.HystrixFeign;
import java.util.ArrayList;
import org.springblade.core.cloud.feign.BladeFeignRequestHeaderInterceptor;
import org.springblade.core.cloud.feign.BladeSpringMvcContract;
import org.springblade.core.tool.convert.EnumToStringConverter;
import org.springblade.core.tool.convert.StringToEnumConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.cloud.openfeign.BladeFeignClientsRegistrar;
import org.springframework.cloud.openfeign.BladeHystrixTargeter;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.Targeter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;

@Configuration
@ConditionalOnClass(value={Feign.class})
@Import(value={BladeFeignClientsRegistrar.class})
@AutoConfigureAfter(value={EnableFeignClients.class})
public class BladeFeignAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={Targeter.class})
    public BladeHystrixTargeter bladeFeignTargeter() {
        return new BladeHystrixTargeter();
    }

    @Bean
    public Contract feignContract(@Qualifier(value="mvcConversionService") ObjectProvider<ConversionService> objectProvider) {
        ConversionService conversionService = (ConversionService)objectProvider.getIfAvailable(DefaultConversionService::new);
        ConverterRegistry converterRegistry = (ConverterRegistry)conversionService;
        converterRegistry.addConverter((GenericConverter)new EnumToStringConverter());
        converterRegistry.addConverter((GenericConverter)new StringToEnumConverter());
        return new BladeSpringMvcContract(new ArrayList<AnnotatedParameterProcessor>(), conversionService);
    }

    @Configuration(value="hystrixFeignConfiguration")
    @ConditionalOnClass(value={HystrixCommand.class, HystrixFeign.class})
    protected static class HystrixFeignConfiguration {
        protected HystrixFeignConfiguration() {
        }

        @Bean
        @Primary
        @Scope(value="prototype")
        @ConditionalOnProperty(value={"feign.hystrix.enabled"})
        public Feign.Builder feignHystrixBuilder(RequestInterceptor requestInterceptor, Contract feignContract) {
            return HystrixFeign.builder().contract(feignContract).decode404().requestInterceptor(requestInterceptor);
        }

        @Bean
        @ConditionalOnMissingBean
        public RequestInterceptor requestInterceptor() {
            return new BladeFeignRequestHeaderInterceptor();
        }
    }
}

