/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.cloud.feign;

import com.alibaba.fastjson.JSONObject;
import feign.FeignException;
import feign.Response;
import feign.RetryableException;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"feign.hystrix.enabled"}, havingValue="false")
public class BladeFeignErrorDecoder
extends ErrorDecoder.Default {
    public Exception decode(String methodKey, Response response) {
        Exception ex = super.decode(methodKey, response);
        if (ex instanceof RetryableException) {
            return ex;
        }
        try {
            if (ex instanceof FeignException && ((FeignException)ex).responseBody().isPresent()) {
                ByteBuffer responseBody = (ByteBuffer)((FeignException)ex).responseBody().get();
                String message = StandardCharsets.UTF_8.newDecoder().decode(responseBody.asReadOnlyBuffer()).toString();
                JSONObject jsonObject = JSONObject.parseObject((String)message);
                return new RuntimeException(jsonObject.getString("msg"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ex;
    }
}

