/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.cloud.version;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import org.springblade.core.cloud.annotation.ApiVersion;
import org.springblade.core.cloud.annotation.UrlVersion;
import org.springblade.core.cloud.version.BladeMediaType;
import org.springblade.core.tool.utils.StringUtil;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class BladeRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    @Nullable
    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo mappinginfo = super.getMappingForMethod(method, handlerType);
        if (mappinginfo != null) {
            RequestMappingInfo apiVersionMappingInfo = this.getApiVersionMappingInfo(method, handlerType);
            return apiVersionMappingInfo == null ? mappinginfo : apiVersionMappingInfo.combine(mappinginfo);
        }
        return null;
    }

    @Nullable
    private RequestMappingInfo getApiVersionMappingInfo(Method method, Class<?> handlerType) {
        boolean nonApiVersion;
        ApiVersion apiVersion;
        UrlVersion urlVersion = (UrlVersion)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, UrlVersion.class);
        if (urlVersion == null || StringUtil.isBlank((CharSequence)urlVersion.value())) {
            urlVersion = (UrlVersion)AnnotatedElementUtils.findMergedAnnotation(handlerType, UrlVersion.class);
        }
        if ((apiVersion = (ApiVersion)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ApiVersion.class)) == null || StringUtil.isBlank((CharSequence)apiVersion.value())) {
            apiVersion = (ApiVersion)AnnotatedElementUtils.findMergedAnnotation(handlerType, ApiVersion.class);
        }
        boolean nonUrlVersion = urlVersion == null || StringUtil.isBlank((CharSequence)urlVersion.value());
        boolean bl = nonApiVersion = apiVersion == null || StringUtil.isBlank((CharSequence)apiVersion.value());
        if (nonUrlVersion && nonApiVersion) {
            return null;
        }
        RequestMappingInfo.Builder mappingInfoBuilder = null;
        mappingInfoBuilder = nonApiVersion ? RequestMappingInfo.paths((String[])new String[]{urlVersion.value()}) : RequestMappingInfo.paths((String[])new String[]{""});
        if (nonUrlVersion) {
            String vsersionMediaTypes = new BladeMediaType(apiVersion.value()).toString();
            mappingInfoBuilder.produces(new String[]{vsersionMediaTypes});
        }
        return mappingInfoBuilder.build();
    }

    protected void handlerMethodsInitialized(Map<RequestMappingInfo, HandlerMethod> handlerMethods) {
        if (this.logger.isInfoEnabled()) {
            for (Map.Entry<RequestMappingInfo, HandlerMethod> entry : handlerMethods.entrySet()) {
                RequestMappingInfo mapping = entry.getKey();
                HandlerMethod handlerMethod = entry.getValue();
                this.logger.info((Object)("Mapped \"" + mapping + "\" onto " + handlerMethod));
            }
        }
        super.handlerMethodsInitialized(handlerMethods);
    }
}

