/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.cloud.header;

import java.util.concurrent.Callable;
import org.springblade.core.cloud.header.BladeFeignAccountGetter;
import org.springblade.core.cloud.header.BladeHttpHeadersContextHolder;
import org.springblade.core.cloud.props.BladeFeignHeadersProperties;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;

public class BladeHttpHeadersCallable<V>
implements Callable<V> {
    private final Callable<V> delegate;
    @Nullable
    private HttpHeaders httpHeaders;

    public BladeHttpHeadersCallable(Callable<V> delegate, @Nullable BladeFeignAccountGetter accountGetter, BladeFeignHeadersProperties properties) {
        this.delegate = delegate;
        this.httpHeaders = BladeHttpHeadersContextHolder.toHeaders(accountGetter, properties);
    }

    @Override
    public V call() throws Exception {
        if (this.httpHeaders == null) {
            return this.delegate.call();
        }
        try {
            BladeHttpHeadersContextHolder.set(this.httpHeaders);
            V v = this.delegate.call();
            return v;
        }
        finally {
            BladeHttpHeadersContextHolder.remove();
            this.httpHeaders.clear();
            this.httpHeaders = null;
        }
    }
}

