/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.context;

import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.MDC;
import org.springblade.core.tool.utils.ThreadLocalUtil;
import org.springframework.lang.Nullable;

public class BladeCallableWrapper<V>
implements Callable<V> {
    private final Callable<V> delegate;
    private final Map<String, Object> tlMap;
    @Nullable
    private final Map<String, String> mdcMap;

    public BladeCallableWrapper(Callable<V> callable) {
        this.delegate = callable;
        this.tlMap = ThreadLocalUtil.getAll();
        this.mdcMap = MDC.getCopyOfContextMap();
    }

    @Override
    public V call() throws Exception {
        if (!this.tlMap.isEmpty()) {
            ThreadLocalUtil.put(this.tlMap);
        }
        if (this.mdcMap != null && !this.mdcMap.isEmpty()) {
            MDC.setContextMap(this.mdcMap);
        }
        try {
            V v = this.delegate.call();
            return v;
        }
        finally {
            this.tlMap.clear();
            if (this.mdcMap != null) {
                this.mdcMap.clear();
            }
            ThreadLocalUtil.clear();
            MDC.clear();
        }
    }
}

