/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.context;

import java.util.function.Function;
import org.springblade.core.context.BladeContext;
import org.springblade.core.context.BladeHttpHeadersGetter;
import org.springblade.core.context.props.BladeContextProperties;
import org.springblade.core.tool.utils.StringUtil;
import org.springblade.core.tool.utils.ThreadLocalUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class BladeServletContext
implements BladeContext {
    private final BladeContextProperties contextProperties;
    private final BladeHttpHeadersGetter httpHeadersGetter;

    @Override
    @Nullable
    public String getRequestId() {
        return this.get(this.contextProperties.getHeaders().getRequestId());
    }

    @Override
    @Nullable
    public String getAccountId() {
        return this.get(this.contextProperties.getHeaders().getAccountId());
    }

    @Override
    @Nullable
    public String getTenantId() {
        return this.get(this.contextProperties.getHeaders().getTenantId());
    }

    @Override
    @Nullable
    public String get(String ctxKey) {
        HttpHeaders headers = (HttpHeaders)ThreadLocalUtil.getIfAbsent((String)"bladeContext", this.httpHeadersGetter::get);
        if (headers == null || headers.isEmpty()) {
            return null;
        }
        return headers.getFirst(ctxKey);
    }

    @Override
    @Nullable
    public <T> T get(String ctxKey, Function<String, T> function) {
        String ctxValue = this.get(ctxKey);
        if (StringUtil.isBlank((CharSequence)ctxValue)) {
            return null;
        }
        return function.apply(ctxKey);
    }

    public BladeServletContext(BladeContextProperties contextProperties, BladeHttpHeadersGetter httpHeadersGetter) {
        this.contextProperties = contextProperties;
        this.httpHeadersGetter = httpHeadersGetter;
    }
}

