/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.context;

import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springblade.core.context.BladeHttpHeadersGetter;
import org.springblade.core.context.props.BladeContextProperties;
import org.springblade.core.tool.utils.StringUtil;
import org.springblade.core.tool.utils.WebUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class ServletHttpHeadersGetter
implements BladeHttpHeadersGetter {
    private final BladeContextProperties properties;

    @Override
    @Nullable
    public HttpHeaders get() {
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            return null;
        }
        return this.get(request);
    }

    @Override
    @Nullable
    public HttpHeaders get(HttpServletRequest request) {
        HttpHeaders headers = new HttpHeaders();
        List<String> crossHeaders = this.properties.getCrossHeaders();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            List<String> allowed = this.properties.getHeaders().getAllowed();
            while (headerNames.hasMoreElements()) {
                String values;
                String key = (String)headerNames.nextElement();
                if (!crossHeaders.contains(key) && !allowed.contains(key) || !StringUtil.isNotBlank((CharSequence)(values = request.getHeader(key)))) continue;
                headers.add(key, values);
            }
        }
        return headers;
    }

    public ServletHttpHeadersGetter(BladeContextProperties properties) {
        this.properties = properties;
    }
}

