/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.context.listener;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;
import org.springblade.core.context.BladeHttpHeadersGetter;
import org.springblade.core.context.props.BladeContextProperties;
import org.springblade.core.tool.utils.StringUtil;
import org.springblade.core.tool.utils.ThreadLocalUtil;
import org.springframework.http.HttpHeaders;

public class BladeServletRequestListener
implements ServletRequestListener {
    private final BladeContextProperties contextProperties;
    private final BladeHttpHeadersGetter httpHeadersGetter;

    public void requestInitialized(ServletRequestEvent event) {
        String tenantId;
        String accountId;
        BladeContextProperties.Headers headers;
        HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
        String requestId = request.getHeader((headers = this.contextProperties.getHeaders()).getRequestId());
        if (StringUtil.isNotBlank((CharSequence)requestId)) {
            MDC.put((String)"requestId", (String)requestId);
        }
        if (StringUtil.isNotBlank((CharSequence)(accountId = request.getHeader(headers.getAccountId())))) {
            MDC.put((String)"accountId", (String)accountId);
        }
        if (StringUtil.isNotBlank((CharSequence)(tenantId = request.getHeader(headers.getTenantId())))) {
            MDC.put((String)"tenantId", (String)tenantId);
        }
        HttpHeaders httpHeaders = this.httpHeadersGetter.get(request);
        ThreadLocalUtil.put((String)"bladeContext", (Object)httpHeaders);
    }

    public void requestDestroyed(ServletRequestEvent event) {
        ThreadLocalUtil.clear();
        MDC.remove((String)"requestId");
        MDC.remove((String)"accountId");
        MDC.remove((String)"tenantId");
    }

    public BladeServletRequestListener(BladeContextProperties contextProperties, BladeHttpHeadersGetter httpHeadersGetter) {
        this.contextProperties = contextProperties;
        this.httpHeadersGetter = httpHeadersGetter;
    }
}

