/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.context.props;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="blade.context")
public class BladeContextProperties {
    public static final String PREFIX = "blade.context";
    private Headers headers = new Headers();

    public List<String> getCrossHeaders() {
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(this.headers.getRequestId());
        headerList.add(this.headers.getAccountId());
        headerList.add(this.headers.getTenantId());
        headerList.addAll(this.headers.getAllowed());
        return headerList;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    public static class Headers {
        private String requestId = "Blade-RequestId";
        private String accountId = "Blade-AccountId";
        private String tenantId = "Blade-TenantId";
        private List<String> allowed = Arrays.asList("X-Real-IP", "x-forwarded-for", "authorization", "Authorization", "Blade-Auth".toLowerCase(), "Blade-Auth");

        public String getRequestId() {
            return this.requestId;
        }

        public String getAccountId() {
            return this.accountId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public List<String> getAllowed() {
            return this.allowed;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public void setAllowed(List<String> allowed) {
            this.allowed = allowed;
        }
    }
}

