/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.launch.props;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.lang.Nullable;

@ConfigurationProperties(value="blade")
public class BladeProperties {
    private String env;
    private String name;
    private Boolean isLocal = Boolean.FALSE;
    private final Map<String, String> prop = new HashMap<String, String>();

    @Nullable
    public String get(String key) {
        return this.get(key, null);
    }

    @Nullable
    public String get(String key, @Nullable String defaultValue) {
        String value = this.prop.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Nullable
    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    @Nullable
    public Integer getInt(String key, @Nullable Integer defaultValue) {
        String value = this.prop.get(key);
        if (value != null) {
            return Integer.valueOf(value.trim());
        }
        return defaultValue;
    }

    @Nullable
    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    @Nullable
    public Long getLong(String key, @Nullable Long defaultValue) {
        String value = this.prop.get(key);
        if (value != null) {
            return Long.valueOf(value.trim());
        }
        return defaultValue;
    }

    @Nullable
    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    @Nullable
    public Boolean getBoolean(String key, @Nullable Boolean defaultValue) {
        String value = this.prop.get(key);
        if (value != null) {
            value = value.toLowerCase().trim();
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    @Nullable
    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    @Nullable
    public Double getDouble(String key, @Nullable Double defaultValue) {
        String value = this.prop.get(key);
        if (value != null) {
            return Double.parseDouble(value.trim());
        }
        return defaultValue;
    }

    public boolean containsKey(String key) {
        return this.prop.containsKey(key);
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getIsLocal() {
        return this.isLocal;
    }

    public void setIsLocal(Boolean isLocal) {
        this.isLocal = isLocal;
    }

    public Map<String, String> getProp() {
        return this.prop;
    }
}

