/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.launch.server;

import org.springblade.core.launch.utils.INetUtil;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class ServerInfo
implements SmartInitializingSingleton {
    private final ServerProperties serverProperties;
    private String hostName;
    private String ip;
    private Integer port;
    private String ipWithPort;

    @Autowired(required=false)
    public ServerInfo(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void afterSingletonsInstantiated() {
        this.hostName = INetUtil.getHostName();
        this.ip = INetUtil.getHostIp();
        this.port = this.serverProperties.getPort();
        this.ipWithPort = String.format("%s:%d", this.ip, this.port);
    }

    public ServerProperties getServerProperties() {
        return this.serverProperties;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getIp() {
        return this.ip;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getIpWithPort() {
        return this.ipWithPort;
    }
}

