/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.log.event;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.launch.props.BladeProperties;
import org.springblade.core.launch.server.ServerInfo;
import org.springblade.core.log.event.ErrorLogEvent;
import org.springblade.core.log.feign.ILogClient;
import org.springblade.core.log.model.LogError;
import org.springblade.core.log.utils.LogAbstractUtil;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;

public class ErrorLogListener {
    private static final Logger log = LoggerFactory.getLogger(ErrorLogListener.class);
    private final ILogClient logService;
    private final ServerInfo serverInfo;
    private final BladeProperties bladeProperties;

    @Async
    @Order
    @EventListener(value={ErrorLogEvent.class})
    public void saveErrorLog(ErrorLogEvent event) {
        Map source = (Map)event.getSource();
        LogError logError = (LogError)source.get("log");
        LogAbstractUtil.addOtherInfoToLog(logError, this.bladeProperties, this.serverInfo);
        this.logService.saveErrorLog(logError);
    }

    public ErrorLogListener(ILogClient logService, ServerInfo serverInfo, BladeProperties bladeProperties) {
        this.logService = logService;
        this.serverInfo = serverInfo;
        this.bladeProperties = bladeProperties;
    }
}

