/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.secure.aspect;

import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springblade.core.secure.annotation.PreAuth;
import org.springblade.core.secure.auth.AuthFun;
import org.springblade.core.secure.exception.SecureException;
import org.springblade.core.tool.api.IResultCode;
import org.springblade.core.tool.api.ResultCode;
import org.springblade.core.tool.utils.ClassUtil;
import org.springblade.core.tool.utils.StringUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.MethodParameter;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.NonNull;

@Aspect
public class AuthAspect
implements ApplicationContextAware {
    private static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private ApplicationContext applicationContext;

    @Around(value="@annotation(org.springblade.core.secure.annotation.PreAuth) || @within(org.springblade.core.secure.annotation.PreAuth)")
    public Object preAuth(ProceedingJoinPoint point) throws Throwable {
        if (this.handleAuth(point)) {
            return point.proceed();
        }
        throw new SecureException((IResultCode)ResultCode.UN_AUTHORIZED);
    }

    private boolean handleAuth(ProceedingJoinPoint point) {
        MethodSignature ms = (MethodSignature)point.getSignature();
        Method method = ms.getMethod();
        PreAuth preAuth = (PreAuth)ClassUtil.getAnnotation((Method)method, PreAuth.class);
        String condition = preAuth.value();
        if (StringUtil.isNotBlank((CharSequence)condition)) {
            Expression expression = EXPRESSION_PARSER.parseExpression(condition);
            Object[] args = point.getArgs();
            StandardEvaluationContext context = this.getEvaluationContext(method, args);
            return (Boolean)expression.getValue((EvaluationContext)context, Boolean.class);
        }
        return false;
    }

    private StandardEvaluationContext getEvaluationContext(Method method, Object[] args) {
        StandardEvaluationContext context = new StandardEvaluationContext((Object)new AuthFun());
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.applicationContext));
        for (int i = 0; i < args.length; ++i) {
            MethodParameter methodParam = ClassUtil.getMethodParameter((Method)method, (int)i);
            context.setVariable(methodParam.getParameterName(), args[i]);
        }
        return context;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

