/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.secure.auth;

import org.springblade.core.secure.BladeUser;
import org.springblade.core.secure.handler.IPermissionHandler;
import org.springblade.core.secure.utils.AuthUtil;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springblade.core.tool.utils.DateUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.SpringUtil;
import org.springblade.core.tool.utils.StringUtil;

public class AuthFun {
    private static IPermissionHandler permissionHandler;

    private static IPermissionHandler getPermissionHandler() {
        if (permissionHandler == null) {
            permissionHandler = (IPermissionHandler)SpringUtil.getBean(IPermissionHandler.class);
        }
        return permissionHandler;
    }

    public boolean permissionAll() {
        return AuthFun.getPermissionHandler().permissionAll();
    }

    public boolean hasPermission(String permission) {
        return AuthFun.getPermissionHandler().hasPermission(permission);
    }

    public boolean permitAll() {
        return true;
    }

    public boolean denyAll() {
        return this.hasRole("admin");
    }

    public boolean hasAuth() {
        return Func.isNotEmpty((Object)AuthUtil.getUser());
    }

    public boolean hasTimeAuth(Integer start, Integer end) {
        Integer hour = DateUtil.hour();
        return hour >= start && hour <= end;
    }

    public boolean hasRole(String role) {
        return this.hasAnyRole(role);
    }

    public boolean hasAllRole(String ... role) {
        for (String r : role) {
            if (this.hasRole(r)) continue;
            return false;
        }
        return true;
    }

    public boolean hasAnyRole(String ... role) {
        BladeUser user = AuthUtil.getUser();
        if (user == null) {
            return false;
        }
        String userRole = user.getRoleName();
        if (StringUtil.isBlank((CharSequence)userRole)) {
            return false;
        }
        Object[] roles = Func.toStrArray((String)userRole);
        for (String r : role) {
            if (!CollectionUtil.contains((Object[])roles, (Object)r)) continue;
            return true;
        }
        return false;
    }

    public boolean isAdminTenant() {
        BladeUser user = AuthUtil.getUser();
        if (user == null) {
            return false;
        }
        String tenantId = user.getTenantId();
        if (StringUtil.isBlank((CharSequence)tenantId)) {
            return false;
        }
        return Func.equals((Object)tenantId, (Object)"000000");
    }

    public boolean isAdminClient() {
        BladeUser user = AuthUtil.getUser();
        if (user == null) {
            return false;
        }
        String clientId = user.getClientId();
        if (StringUtil.isBlank((CharSequence)clientId)) {
            return false;
        }
        return Func.equals((Object)clientId, (Object)"caigouwang");
    }
}

