/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.secure.config;

import org.springblade.core.secure.config.SecureConfiguration;
import org.springblade.core.secure.handler.BladePermissionHandler;
import org.springblade.core.secure.handler.IPermissionHandler;
import org.springblade.core.secure.handler.ISecureHandler;
import org.springblade.core.secure.handler.SecureHandlerHandler;
import org.springblade.core.secure.registry.SecureRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;

@Order
@Configuration
@AutoConfigureBefore(value={SecureConfiguration.class})
public class RegistryConfiguration {
    private final JdbcTemplate jdbcTemplate;

    @Bean
    @ConditionalOnMissingBean(value={SecureRegistry.class})
    public SecureRegistry secureRegistry() {
        return new SecureRegistry();
    }

    @Bean
    @ConditionalOnMissingBean(value={ISecureHandler.class})
    public ISecureHandler secureHandler() {
        return new SecureHandlerHandler();
    }

    @Bean
    @ConditionalOnMissingBean(value={IPermissionHandler.class})
    public IPermissionHandler permissionHandler() {
        return new BladePermissionHandler(this.jdbcTemplate);
    }

    public RegistryConfiguration(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

