/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.secure.config;

import java.util.List;
import java.util.stream.Collectors;
import org.springblade.core.secure.aspect.AuthAspect;
import org.springblade.core.secure.handler.ISecureHandler;
import org.springblade.core.secure.props.AuthSecure;
import org.springblade.core.secure.props.BasicSecure;
import org.springblade.core.secure.props.BladeSecureProperties;
import org.springblade.core.secure.provider.ClientDetailsServiceImpl;
import org.springblade.core.secure.provider.IClientDetailsService;
import org.springblade.core.secure.registry.SecureRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Order
@Configuration
@EnableConfigurationProperties(value={BladeSecureProperties.class})
public class SecureConfiguration
implements WebMvcConfigurer {
    private final SecureRegistry secureRegistry;
    private final BladeSecureProperties secureProperties;
    private final JdbcTemplate jdbcTemplate;
    private final ISecureHandler secureHandler;

    public void addInterceptors(@NonNull InterceptorRegistry registry) {
        List<BasicSecure> basicSecures;
        List<AuthSecure> authSecures;
        if ((this.secureRegistry.isAuthEnabled() || this.secureProperties.getAuthEnabled().booleanValue()) && (authSecures = this.secureRegistry.addAuthPatterns(this.secureProperties.getAuth()).getAuthSecures()).size() > 0) {
            registry.addInterceptor((HandlerInterceptor)this.secureHandler.authInterceptor(authSecures));
        }
        if ((this.secureRegistry.isBasicEnabled() || this.secureProperties.getBasicEnabled().booleanValue()) && (basicSecures = this.secureRegistry.addBasicPatterns(this.secureProperties.getBasic()).getBasicSecures()).size() > 0) {
            registry.addInterceptor((HandlerInterceptor)this.secureHandler.basicInterceptor(basicSecures));
            this.secureRegistry.excludePathPatterns(basicSecures.stream().map(BasicSecure::getPattern).collect(Collectors.toList()));
        }
        if (this.secureRegistry.isClientEnabled() || this.secureProperties.getClientEnabled().booleanValue()) {
            this.secureProperties.getClient().forEach(clientSecure -> registry.addInterceptor((HandlerInterceptor)this.secureHandler.clientInterceptor(clientSecure.getClientId())).addPathPatterns(clientSecure.getPathPatterns()));
        }
        if (this.secureRegistry.isEnabled() || this.secureProperties.getEnabled().booleanValue()) {
            registry.addInterceptor((HandlerInterceptor)this.secureHandler.tokenInterceptor()).excludePathPatterns(this.secureRegistry.getExcludePatterns()).excludePathPatterns(this.secureRegistry.getDefaultExcludePatterns()).excludePathPatterns(this.secureProperties.getSkipUrl());
        }
    }

    @Bean
    public AuthAspect authAspect() {
        return new AuthAspect();
    }

    @Bean
    @ConditionalOnMissingBean(value={IClientDetailsService.class})
    public IClientDetailsService clientDetailsService() {
        return new ClientDetailsServiceImpl(this.jdbcTemplate);
    }

    public SecureConfiguration(SecureRegistry secureRegistry, BladeSecureProperties secureProperties, JdbcTemplate jdbcTemplate, ISecureHandler secureHandler) {
        this.secureRegistry = secureRegistry;
        this.secureProperties = secureProperties;
        this.jdbcTemplate = jdbcTemplate;
        this.secureHandler = secureHandler;
    }
}

