/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.secure.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springblade.core.cache.utils.CacheUtil;
import org.springblade.core.secure.BladeUser;
import org.springblade.core.secure.constant.PermissionConstant;
import org.springblade.core.secure.handler.IPermissionHandler;
import org.springblade.core.secure.utils.AuthUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.WebUtil;
import org.springframework.jdbc.core.JdbcTemplate;

public class BladePermissionHandler
implements IPermissionHandler {
    private static final String SCOPE_CACHE_CODE = "apiScope:code:";
    private final JdbcTemplate jdbcTemplate;

    @Override
    public boolean permissionAll() {
        HttpServletRequest request = WebUtil.getRequest();
        BladeUser user = AuthUtil.getUser();
        if (request == null || user == null) {
            return false;
        }
        String uri = request.getRequestURI();
        List<String> paths = this.permissionPath(user.getRoleId());
        if (paths.size() == 0) {
            return false;
        }
        return paths.stream().anyMatch(uri::contains);
    }

    @Override
    public boolean hasPermission(String permission) {
        HttpServletRequest request = WebUtil.getRequest();
        BladeUser user = AuthUtil.getUser();
        if (request == null || user == null) {
            return false;
        }
        List<String> codes = this.permissionCode(permission, user.getRoleId());
        return codes.size() != 0;
    }

    private List<String> permissionPath(String roleId) {
        List permissions = (List)CacheUtil.get((String)"blade:sys", (String)SCOPE_CACHE_CODE, (Object)roleId, List.class);
        if (permissions == null) {
            List roleIds = Func.toLongList((String)roleId);
            permissions = this.jdbcTemplate.queryForList(PermissionConstant.permissionAllStatement(roleIds.size()), roleIds.toArray(), String.class);
            CacheUtil.put((String)"blade:sys", (String)SCOPE_CACHE_CODE, (Object)roleId, (Object)permissions);
        }
        return permissions;
    }

    private List<String> permissionCode(String permission, String roleId) {
        List permissions = (List)CacheUtil.get((String)"blade:sys", (String)SCOPE_CACHE_CODE, (Object)(permission + ":" + roleId), List.class);
        if (permissions == null) {
            ArrayList<String> args = new ArrayList<String>(Collections.singletonList(permission));
            List roleIds = Func.toLongList((String)roleId);
            args.addAll(roleIds);
            permissions = this.jdbcTemplate.queryForList(PermissionConstant.permissionStatement(roleIds.size()), args.toArray(), String.class);
            CacheUtil.put((String)"blade:sys", (String)SCOPE_CACHE_CODE, (Object)(permission + ":" + roleId), (Object)permissions);
        }
        return permissions;
    }

    public BladePermissionHandler(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

