/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.secure.handler;

import java.util.List;
import org.springblade.core.secure.handler.ISecureHandler;
import org.springblade.core.secure.interceptor.AuthInterceptor;
import org.springblade.core.secure.interceptor.BasicInterceptor;
import org.springblade.core.secure.interceptor.ClientInterceptor;
import org.springblade.core.secure.interceptor.TokenInterceptor;
import org.springblade.core.secure.props.AuthSecure;
import org.springblade.core.secure.props.BasicSecure;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class SecureHandlerHandler
implements ISecureHandler {
    @Override
    public HandlerInterceptorAdapter tokenInterceptor() {
        return new TokenInterceptor();
    }

    @Override
    public HandlerInterceptorAdapter authInterceptor(List<AuthSecure> authSecures) {
        return new AuthInterceptor(authSecures);
    }

    @Override
    public HandlerInterceptorAdapter basicInterceptor(List<BasicSecure> basicSecures) {
        return new BasicInterceptor(basicSecures);
    }

    @Override
    public HandlerInterceptorAdapter clientInterceptor(String clientId) {
        return new ClientInterceptor(clientId);
    }
}

