/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.secure.interceptor;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.secure.auth.AuthFun;
import org.springblade.core.secure.props.AuthSecure;
import org.springblade.core.secure.provider.HttpMethod;
import org.springblade.core.secure.provider.ResponseProvider;
import org.springblade.core.tool.jackson.JsonUtil;
import org.springblade.core.tool.utils.WebUtil;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.NonNull;
import org.springframework.util.PatternMatchUtils;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AuthInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(AuthInterceptor.class);
    private static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private static final EvaluationContext EVALUATION_CONTEXT = new StandardEvaluationContext((Object)new AuthFun());
    private final List<AuthSecure> authSecures;

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) {
        boolean check = this.authSecures.stream().filter(authSecure -> this.checkAuth(request, (AuthSecure)authSecure)).findFirst().map(authSecure -> this.checkExpression(authSecure.getExpression())).orElse(Boolean.TRUE);
        if (!check) {
            log.warn("\u6388\u6743\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u6c42\u63a5\u53e3\uff1a{}\uff0c\u8bf7\u6c42IP\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{request.getRequestURI(), WebUtil.getIP((HttpServletRequest)request), JsonUtil.toJson((Object)request.getParameterMap())});
            ResponseProvider.write(response);
            return false;
        }
        return true;
    }

    private boolean checkAuth(HttpServletRequest request, AuthSecure authSecure) {
        return this.checkMethod(request, authSecure.getMethod()) && this.checkPath(request, authSecure.getPattern());
    }

    private boolean checkMethod(HttpServletRequest request, HttpMethod method) {
        return method == HttpMethod.ALL || method != null && method == HttpMethod.of(request.getMethod());
    }

    private boolean checkPath(HttpServletRequest request, String pattern) {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && pathInfo.length() > 0) {
            servletPath = servletPath + pathInfo;
        }
        return PatternMatchUtils.simpleMatch((String)pattern, (String)servletPath);
    }

    private boolean checkExpression(String expression) {
        Boolean result = (Boolean)EXPRESSION_PARSER.parseExpression(expression).getValue(EVALUATION_CONTEXT, Boolean.class);
        return result != null ? result : false;
    }

    public AuthInterceptor(List<AuthSecure> authSecures) {
        this.authSecures = authSecures;
    }
}

