/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.secure.interceptor;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.secure.props.BasicSecure;
import org.springblade.core.secure.provider.HttpMethod;
import org.springblade.core.secure.provider.ResponseProvider;
import org.springblade.core.secure.utils.SecureUtil;
import org.springblade.core.tool.jackson.JsonUtil;
import org.springblade.core.tool.utils.WebUtil;
import org.springframework.lang.NonNull;
import org.springframework.util.PatternMatchUtils;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class BasicInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(BasicInterceptor.class);
    private final List<BasicSecure> basicSecures;

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) {
        boolean check = this.basicSecures.stream().filter(basicSecure -> this.checkAuth(request, (BasicSecure)basicSecure)).findFirst().map(authSecure -> this.checkBasic(authSecure.getUsername(), authSecure.getPassword())).orElse(Boolean.TRUE);
        if (!check) {
            log.warn("\u6388\u6743\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u6c42\u63a5\u53e3\uff1a{}\uff0c\u8bf7\u6c42IP\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{request.getRequestURI(), WebUtil.getIP((HttpServletRequest)request), JsonUtil.toJson((Object)request.getParameterMap())});
            response.setHeader("WWW-Authenticate", "basic realm=\"no auth\"");
            ResponseProvider.write(response);
            return false;
        }
        return true;
    }

    private boolean checkAuth(HttpServletRequest request, BasicSecure basicSecure) {
        return this.checkMethod(request, basicSecure.getMethod()) && this.checkPath(request, basicSecure.getPattern());
    }

    private boolean checkMethod(HttpServletRequest request, HttpMethod method) {
        return method == HttpMethod.ALL || method != null && method == HttpMethod.of(request.getMethod());
    }

    private boolean checkPath(HttpServletRequest request, String pattern) {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && pathInfo.length() > 0) {
            servletPath = servletPath + pathInfo;
        }
        return PatternMatchUtils.simpleMatch((String)pattern, (String)servletPath);
    }

    private boolean checkBasic(String username, String password) {
        try {
            String[] tokens = SecureUtil.extractAndDecodeHeader();
            return username.equals(tokens[0]) && password.equals(tokens[1]);
        }
        catch (Exception e) {
            log.warn("\u6388\u6743\u8ba4\u8bc1\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            return false;
        }
    }

    public BasicInterceptor(List<BasicSecure> basicSecures) {
        this.basicSecures = basicSecures;
    }
}

