/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.secure.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springblade.core.secure.props.AuthSecure;
import org.springblade.core.secure.props.BasicSecure;
import org.springblade.core.secure.provider.HttpMethod;

public class SecureRegistry {
    private boolean enabled = false;
    private boolean authEnabled = true;
    private boolean basicEnabled = true;
    private boolean clientEnabled = true;
    private final List<String> defaultExcludePatterns = new ArrayList<String>();
    private final List<String> excludePatterns = new ArrayList<String>();
    private final List<AuthSecure> authSecures = new ArrayList<AuthSecure>();
    private final List<BasicSecure> basicSecures = new ArrayList<BasicSecure>();

    public SecureRegistry() {
        this.defaultExcludePatterns.add("/actuator/health/**");
        this.defaultExcludePatterns.add("/v2/api-docs/**");
        this.defaultExcludePatterns.add("/auth/**");
        this.defaultExcludePatterns.add("/token/**");
        this.defaultExcludePatterns.add("/log/**");
        this.defaultExcludePatterns.add("/menu/routes");
        this.defaultExcludePatterns.add("/menu/auth-routes");
        this.defaultExcludePatterns.add("/menu/top-menu");
        this.defaultExcludePatterns.add("/process/resource-view");
        this.defaultExcludePatterns.add("/process/diagram-view");
        this.defaultExcludePatterns.add("/manager/check-upload");
        this.defaultExcludePatterns.add("/error/**");
        this.defaultExcludePatterns.add("/assets/**");
    }

    public SecureRegistry excludePathPattern(String pattern) {
        this.excludePatterns.add(pattern);
        return this;
    }

    public SecureRegistry excludePathPatterns(String ... patterns) {
        this.excludePatterns.addAll(Arrays.asList(patterns));
        return this;
    }

    public SecureRegistry excludePathPatterns(List<String> patterns) {
        this.excludePatterns.addAll(patterns);
        return this;
    }

    public SecureRegistry addAuthPattern(HttpMethod method, String pattern, String expression) {
        this.authSecures.add(new AuthSecure(method, pattern, expression));
        return this;
    }

    public SecureRegistry addAuthPatterns(List<AuthSecure> authSecures) {
        this.authSecures.addAll(authSecures);
        return this;
    }

    public List<AuthSecure> getAuthSecures() {
        return this.authSecures;
    }

    public SecureRegistry addBasicPattern(HttpMethod method, String pattern, String username, String password) {
        this.basicSecures.add(new BasicSecure(method, pattern, username, password));
        return this;
    }

    public SecureRegistry addBasicPatterns(List<BasicSecure> basicSecures) {
        this.basicSecures.addAll(basicSecures);
        return this;
    }

    public List<BasicSecure> getBasicSecures() {
        return this.basicSecures;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public boolean isBasicEnabled() {
        return this.basicEnabled;
    }

    public boolean isClientEnabled() {
        return this.clientEnabled;
    }

    public List<String> getDefaultExcludePatterns() {
        return this.defaultExcludePatterns;
    }

    public List<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setAuthEnabled(boolean authEnabled) {
        this.authEnabled = authEnabled;
    }

    public void setBasicEnabled(boolean basicEnabled) {
        this.basicEnabled = basicEnabled;
    }

    public void setClientEnabled(boolean clientEnabled) {
        this.clientEnabled = clientEnabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecureRegistry)) {
            return false;
        }
        SecureRegistry other = (SecureRegistry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isAuthEnabled() != other.isAuthEnabled()) {
            return false;
        }
        if (this.isBasicEnabled() != other.isBasicEnabled()) {
            return false;
        }
        if (this.isClientEnabled() != other.isClientEnabled()) {
            return false;
        }
        List<String> this$defaultExcludePatterns = this.getDefaultExcludePatterns();
        List<String> other$defaultExcludePatterns = other.getDefaultExcludePatterns();
        if (this$defaultExcludePatterns == null ? other$defaultExcludePatterns != null : !((Object)this$defaultExcludePatterns).equals(other$defaultExcludePatterns)) {
            return false;
        }
        List<String> this$excludePatterns = this.getExcludePatterns();
        List<String> other$excludePatterns = other.getExcludePatterns();
        if (this$excludePatterns == null ? other$excludePatterns != null : !((Object)this$excludePatterns).equals(other$excludePatterns)) {
            return false;
        }
        List<AuthSecure> this$authSecures = this.getAuthSecures();
        List<AuthSecure> other$authSecures = other.getAuthSecures();
        if (this$authSecures == null ? other$authSecures != null : !((Object)this$authSecures).equals(other$authSecures)) {
            return false;
        }
        List<BasicSecure> this$basicSecures = this.getBasicSecures();
        List<BasicSecure> other$basicSecures = other.getBasicSecures();
        return !(this$basicSecures == null ? other$basicSecures != null : !((Object)this$basicSecures).equals(other$basicSecures));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecureRegistry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isAuthEnabled() ? 79 : 97);
        result = result * 59 + (this.isBasicEnabled() ? 79 : 97);
        result = result * 59 + (this.isClientEnabled() ? 79 : 97);
        List<String> $defaultExcludePatterns = this.getDefaultExcludePatterns();
        result = result * 59 + ($defaultExcludePatterns == null ? 43 : ((Object)$defaultExcludePatterns).hashCode());
        List<String> $excludePatterns = this.getExcludePatterns();
        result = result * 59 + ($excludePatterns == null ? 43 : ((Object)$excludePatterns).hashCode());
        List<AuthSecure> $authSecures = this.getAuthSecures();
        result = result * 59 + ($authSecures == null ? 43 : ((Object)$authSecures).hashCode());
        List<BasicSecure> $basicSecures = this.getBasicSecures();
        result = result * 59 + ($basicSecures == null ? 43 : ((Object)$basicSecures).hashCode());
        return result;
    }

    public String toString() {
        return "SecureRegistry(enabled=" + this.isEnabled() + ", authEnabled=" + this.isAuthEnabled() + ", basicEnabled=" + this.isBasicEnabled() + ", clientEnabled=" + this.isClientEnabled() + ", defaultExcludePatterns=" + this.getDefaultExcludePatterns() + ", excludePatterns=" + this.getExcludePatterns() + ", authSecures=" + this.getAuthSecures() + ", basicSecures=" + this.getBasicSecures() + ")";
    }
}

