/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.secure.utils;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import javax.crypto.spec.SecretKeySpec;
import org.springblade.core.jwt.JwtUtil;
import org.springblade.core.jwt.props.JwtProperties;
import org.springblade.core.secure.TokenInfo;
import org.springblade.core.secure.exception.SecureException;
import org.springblade.core.secure.provider.IClientDetails;
import org.springblade.core.secure.provider.IClientDetailsService;
import org.springblade.core.secure.utils.AuthUtil;
import org.springblade.core.tool.utils.Charsets;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.SpringUtil;
import org.springblade.core.tool.utils.StringUtil;
import org.springblade.core.tool.utils.WebUtil;

public class SecureUtil
extends AuthUtil {
    private static final String CLIENT_ID = "client_id";
    private static IClientDetailsService clientDetailsService;
    private static JwtProperties jwtProperties;

    private static IClientDetailsService getClientDetailsService() {
        if (clientDetailsService == null) {
            clientDetailsService = (IClientDetailsService)SpringUtil.getBean(IClientDetailsService.class);
        }
        return clientDetailsService;
    }

    private static JwtProperties getJwtProperties() {
        if (jwtProperties == null) {
            jwtProperties = (JwtProperties)SpringUtil.getBean(JwtProperties.class);
        }
        return jwtProperties;
    }

    public static TokenInfo createJWT(Map<String, Object> user, String audience, String issuer, String tokenType) {
        String[] tokens = SecureUtil.extractAndDecodeHeader();
        String clientId = tokens[0];
        String clientSecret = tokens[1];
        IClientDetails clientDetails = SecureUtil.clientDetails(clientId);
        if (!SecureUtil.validateClient(clientDetails, clientId, clientSecret)) {
            throw new SecureException("client authentication failed, please check the header parameters");
        }
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        byte[] apiKeySecretBytes = Base64.getDecoder().decode(JwtUtil.getBase64Security());
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        JwtBuilder builder = Jwts.builder().setHeaderParam("typ", (Object)"JWT").setIssuer(issuer).setAudience(audience).signWith((Key)signingKey);
        user.forEach((arg_0, arg_1) -> ((JwtBuilder)builder).claim(arg_0, arg_1));
        builder.claim(CLIENT_ID, (Object)clientId);
        long expireMillis = tokenType.equals("access_token") ? (long)(clientDetails.getAccessTokenValidity() * 1000) : (tokenType.equals("refresh_token") ? (long)(clientDetails.getRefreshTokenValidity() * 1000) : SecureUtil.getExpire());
        long expMillis = nowMillis + expireMillis;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp).setNotBefore(now);
        TokenInfo tokenInfo = new TokenInfo();
        tokenInfo.setToken(builder.compact());
        tokenInfo.setExpire((int)expireMillis / 1000);
        if (SecureUtil.getJwtProperties().getState().booleanValue() && "access_token".equals(tokenType)) {
            String tenantId = String.valueOf(user.get("tenant_id"));
            String userId = String.valueOf(user.get("user_id"));
            JwtUtil.addAccessToken((String)tenantId, (String)userId, (String)tokenInfo.getToken(), (int)tokenInfo.getExpire());
        }
        return tokenInfo;
    }

    public static long getExpire() {
        Calendar cal = Calendar.getInstance();
        cal.add(6, 1);
        cal.set(11, 3);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis() - System.currentTimeMillis();
    }

    public static String[] extractAndDecodeHeader() {
        byte[] decoded;
        String header = Objects.requireNonNull(WebUtil.getRequest()).getHeader("Authorization");
        header = Func.toStr((Object)header).replace("Basic%20", "Basic ");
        if (!header.startsWith("Basic ")) {
            throw new SecureException("no client information in request header");
        }
        byte[] base64Token = header.substring(6).getBytes(Charsets.UTF_8_NAME);
        try {
            decoded = Base64.getDecoder().decode(base64Token);
        }
        catch (IllegalArgumentException var7) {
            throw new RuntimeException("failed to decode basic authentication token");
        }
        String token = new String(decoded, Charsets.UTF_8_NAME);
        int index = token.indexOf(":");
        if (index == -1) {
            throw new RuntimeException("invalid basic authentication token");
        }
        return new String[]{token.substring(0, index), token.substring(index + 1)};
    }

    public static String getClientIdFromHeader() {
        String[] tokens = SecureUtil.extractAndDecodeHeader();
        assert (tokens.length == 2);
        return tokens[0];
    }

    private static IClientDetails clientDetails(String clientId) {
        return SecureUtil.getClientDetailsService().loadClientByClientId(clientId);
    }

    private static boolean validateClient(IClientDetails clientDetails, String clientId, String clientSecret) {
        if (clientDetails != null) {
            return StringUtil.equals((CharSequence)clientId, (CharSequence)clientDetails.getClientId()) && StringUtil.equals((CharSequence)clientSecret, (CharSequence)clientDetails.getClientSecret());
        }
        return false;
    }
}

