/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.secure.config;

import org.springblade.core.secure.aspect.AuthAspect;
import org.springblade.core.secure.interceptor.ClientInterceptor;
import org.springblade.core.secure.interceptor.SecureInterceptor;
import org.springblade.core.secure.props.BladeSecureProperties;
import org.springblade.core.secure.provider.ClientDetailsServiceImpl;
import org.springblade.core.secure.provider.IClientDetailsService;
import org.springblade.core.secure.registry.SecureRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Order
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={BladeSecureProperties.class})
public class SecureConfiguration
implements WebMvcConfigurer {
    private final SecureRegistry secureRegistry;
    private final BladeSecureProperties secureProperties;
    private final JdbcTemplate jdbcTemplate;

    public void addInterceptors(InterceptorRegistry registry) {
        this.secureProperties.getClient().forEach(cs -> registry.addInterceptor((HandlerInterceptor)new ClientInterceptor(cs.getClientId())).addPathPatterns(cs.getPathPatterns()));
        if (this.secureRegistry.isEnabled()) {
            registry.addInterceptor((HandlerInterceptor)new SecureInterceptor()).excludePathPatterns(this.secureRegistry.getExcludePatterns()).excludePathPatterns(this.secureRegistry.getDefaultExcludePatterns()).excludePathPatterns(this.secureProperties.getSkipUrl());
        }
    }

    @Bean
    public AuthAspect authAspect() {
        return new AuthAspect();
    }

    @Bean
    @ConditionalOnMissingBean(value={IClientDetailsService.class})
    public IClientDetailsService clientDetailsService() {
        return new ClientDetailsServiceImpl(this.jdbcTemplate);
    }

    public SecureConfiguration(SecureRegistry secureRegistry, BladeSecureProperties secureProperties, JdbcTemplate jdbcTemplate) {
        this.secureRegistry = secureRegistry;
        this.secureProperties = secureProperties;
        this.jdbcTemplate = jdbcTemplate;
    }
}

