/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.beans;

import java.security.ProtectionDomain;
import org.springblade.core.tool.beans.BladeBeanMapEmitter;
import org.springblade.core.tool.beans.BladeBeanMapKey;
import org.springframework.asm.ClassVisitor;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.ReflectUtils;

public abstract class BladeBeanMap
extends BeanMap {
    protected BladeBeanMap() {
    }

    protected BladeBeanMap(Object bean) {
        super(bean);
    }

    public static BladeBeanMap create(Object bean) {
        BladeGenerator gen = new BladeGenerator();
        gen.setBean(bean);
        return gen.create();
    }

    public abstract BladeBeanMap newInstance(Object var1);

    public static class BladeGenerator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(BladeBeanMap.class.getName());
        private Object bean;
        private Class beanClass;
        private int require;

        public BladeGenerator() {
            super(SOURCE);
        }

        public void setBean(Object bean) {
            this.bean = bean;
            if (bean != null) {
                this.beanClass = bean.getClass();
            }
        }

        public void setBeanClass(Class beanClass) {
            this.beanClass = beanClass;
        }

        public void setRequire(int require) {
            this.require = require;
        }

        protected ClassLoader getDefaultClassLoader() {
            return this.beanClass.getClassLoader();
        }

        protected ProtectionDomain getProtectionDomain() {
            return ReflectUtils.getProtectionDomain((Class)this.beanClass);
        }

        public BladeBeanMap create() {
            if (this.beanClass == null) {
                throw new IllegalArgumentException("Class of bean unknown");
            }
            this.setNamePrefix(this.beanClass.getName());
            BladeBeanMapKey key = new BladeBeanMapKey(this.beanClass, this.require);
            return (BladeBeanMap)((Object)super.create((Object)key));
        }

        public void generateClass(ClassVisitor v) throws Exception {
            new BladeBeanMapEmitter(v, this.getClassName(), this.beanClass, this.require);
        }

        protected Object firstInstance(Class type) {
            return ((BeanMap)ReflectUtils.newInstance((Class)type)).newInstance(this.bean);
        }

        protected Object nextInstance(Object instance) {
            return ((BeanMap)instance).newInstance(this.bean);
        }
    }
}

