/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springblade.core.tool.jackson.BladeJacksonProperties;
import org.springblade.core.tool.jackson.MappingApiJackson2HttpMessageConverter;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.datetime.DateFormatter;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.ResourceRegionHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Order(value=-2147483648)
public class MessageConfiguration
implements WebMvcConfigurer {
    private final ObjectMapper objectMapper;
    private final BladeJacksonProperties properties;

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.removeIf(x -> x instanceof StringHttpMessageConverter || x instanceof AbstractJackson2HttpMessageConverter);
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter(StandardCharsets.UTF_8));
        converters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new ResourceRegionHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new MappingApiJackson2HttpMessageConverter(this.objectMapper, this.properties));
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addFormatter((Formatter)new DateFormatter("yyyy-MM-dd"));
        registry.addFormatter((Formatter)new DateFormatter("yyyy-MM-dd HH:mm:ss"));
    }

    public MessageConfiguration(ObjectMapper objectMapper, BladeJacksonProperties properties) {
        this.objectMapper = objectMapper;
        this.properties = properties;
    }
}

