/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.convert;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.tool.function.CheckedFunction;
import org.springblade.core.tool.utils.ClassUtil;
import org.springblade.core.tool.utils.ConvertUtil;
import org.springblade.core.tool.utils.ReflectUtil;
import org.springblade.core.tool.utils.Unchecked;
import org.springframework.cglib.core.Converter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;

public class BladeConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(BladeConverter.class);
    private static final ConcurrentMap<String, TypeDescriptor> TYPE_CACHE = new ConcurrentHashMap<String, TypeDescriptor>();
    private final Class<?> sourceClazz;
    private final Class<?> targetClazz;

    @Nullable
    public Object convert(Object value, Class target, Object fieldName) {
        if (value == null) {
            return null;
        }
        if (ClassUtil.isAssignableValue((Class)target, (Object)value)) {
            return value;
        }
        try {
            TypeDescriptor targetDescriptor = BladeConverter.getTypeDescriptor(this.targetClazz, (String)fieldName);
            if (Map.class.isAssignableFrom(this.sourceClazz)) {
                return ConvertUtil.convert(value, targetDescriptor);
            }
            TypeDescriptor sourceDescriptor = BladeConverter.getTypeDescriptor(this.sourceClazz, (String)fieldName);
            return ConvertUtil.convert(value, sourceDescriptor, targetDescriptor);
        }
        catch (Throwable e) {
            log.warn("BladeConverter error", e);
            return null;
        }
    }

    private static TypeDescriptor getTypeDescriptor(Class<?> clazz, String fieldName) {
        String srcCacheKey = clazz.getName() + fieldName;
        CheckedFunction<String, TypeDescriptor> uncheckedFunction = key -> {
            Field field = ReflectUtil.getField(clazz, fieldName);
            if (field == null) {
                throw new NoSuchFieldException(fieldName);
            }
            return new TypeDescriptor(field);
        };
        return TYPE_CACHE.computeIfAbsent(srcCacheKey, Unchecked.function(uncheckedFunction));
    }

    public BladeConverter(Class<?> sourceClazz, Class<?> targetClazz) {
        this.sourceClazz = sourceClazz;
        this.targetClazz = targetClazz;
    }
}

