/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.support;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springblade.core.tool.utils.Exceptions;
import org.springframework.lang.Nullable;

public class Try {
    public static <T, R> Function<T, R> of(UncheckedFunction<T, R> mapper) {
        Objects.requireNonNull(mapper);
        return t -> {
            try {
                return mapper.apply(t);
            }
            catch (Exception e) {
                throw Exceptions.unchecked(e);
            }
        };
    }

    public static <T> Consumer<T> of(UncheckedConsumer<T> mapper) {
        Objects.requireNonNull(mapper);
        return t -> {
            try {
                mapper.accept(t);
            }
            catch (Exception e) {
                throw Exceptions.unchecked(e);
            }
        };
    }

    public static <T> Supplier<T> of(UncheckedSupplier<T> mapper) {
        Objects.requireNonNull(mapper);
        return () -> {
            try {
                return mapper.get();
            }
            catch (Exception e) {
                throw Exceptions.unchecked(e);
            }
        };
    }

    @FunctionalInterface
    public static interface UncheckedFunction<T, R> {
        @Nullable
        public R apply(@Nullable T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface UncheckedConsumer<T> {
        @Nullable
        public void accept(@Nullable T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface UncheckedSupplier<T> {
        @Nullable
        public T get() throws Exception;
    }
}

