/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springblade.core.tool.beans.BeanProperty;
import org.springblade.core.tool.beans.BladeBeanCopier;
import org.springblade.core.tool.beans.BladeBeanMap;
import org.springblade.core.tool.convert.BladeConverter;
import org.springblade.core.tool.utils.ClassUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.cglib.beans.BeanGenerator;
import org.springframework.lang.Nullable;

public class BeanUtil
extends BeanUtils {
    public static <T> T newInstance(Class<?> clazz) {
        return (T)BeanUtil.instantiateClass(clazz);
    }

    public static <T> T newInstance(String clazzStr) {
        try {
            Class clazz = ClassUtil.forName((String)clazzStr, null);
            return BeanUtil.newInstance(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static Object getProperty(@Nullable Object bean, String propertyName) {
        if (bean == null) {
            return null;
        }
        BeanWrapper beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        return beanWrapper.getPropertyValue(propertyName);
    }

    public static void setProperty(Object bean, String propertyName, Object value) {
        Objects.requireNonNull(bean, "bean Could not null");
        BeanWrapper beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        beanWrapper.setPropertyValue(propertyName, value);
    }

    @Nullable
    public static <T> T clone(@Nullable T source) {
        if (source == null) {
            return null;
        }
        return (T)BeanUtil.copy(source, source.getClass());
    }

    @Nullable
    public static <T> T copy(@Nullable Object source, Class<T> clazz) {
        if (source == null) {
            return null;
        }
        return BeanUtil.copy(source, source.getClass(), clazz);
    }

    @Nullable
    public static <T> T copy(@Nullable Object source, Class sourceClazz, Class<T> targetClazz) {
        if (source == null) {
            return null;
        }
        BladeBeanCopier copier = BladeBeanCopier.create(sourceClazz, targetClazz, false);
        T to = BeanUtil.newInstance(targetClazz);
        copier.copy(source, to, null);
        return to;
    }

    public static <T> List<T> copy(@Nullable Collection<?> sourceList, Class<T> targetClazz) {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> outList = new ArrayList<T>(sourceList.size());
        Class<?> sourceClazz = null;
        for (Object source : sourceList) {
            if (source == null) continue;
            if (sourceClazz == null) {
                sourceClazz = source.getClass();
            }
            T bean = BeanUtil.copy(source, sourceClazz, targetClazz);
            outList.add(bean);
        }
        return outList;
    }

    public static void copy(@Nullable Object source, @Nullable Object targetBean) {
        if (source == null || targetBean == null) {
            return;
        }
        BladeBeanCopier copier = BladeBeanCopier.create(source.getClass(), targetBean.getClass(), false);
        copier.copy(source, targetBean, null);
    }

    public static void copyNonNull(@Nullable Object source, @Nullable Object targetBean) {
        if (source == null || targetBean == null) {
            return;
        }
        BladeBeanCopier copier = BladeBeanCopier.create(source.getClass(), targetBean.getClass(), false, true);
        copier.copy(source, targetBean, null);
    }

    @Nullable
    public static <T> T copyWithConvert(@Nullable Object source, Class<T> targetClazz) {
        if (source == null) {
            return null;
        }
        return BeanUtil.copyWithConvert(source, source.getClass(), targetClazz);
    }

    @Nullable
    public static <T> T copyWithConvert(@Nullable Object source, Class<?> sourceClazz, Class<T> targetClazz) {
        if (source == null) {
            return null;
        }
        BladeBeanCopier copier = BladeBeanCopier.create(sourceClazz, targetClazz, true);
        T to = BeanUtil.newInstance(targetClazz);
        copier.copy(source, to, new BladeConverter(sourceClazz, targetClazz));
        return to;
    }

    public static <T> List<T> copyWithConvert(@Nullable Collection<?> sourceList, Class<T> targetClazz) {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> outList = new ArrayList<T>(sourceList.size());
        Class<?> sourceClazz = null;
        for (Object source : sourceList) {
            if (source == null) continue;
            if (sourceClazz == null) {
                sourceClazz = source.getClass();
            }
            T bean = BeanUtil.copyWithConvert(source, sourceClazz, targetClazz);
            outList.add(bean);
        }
        return outList;
    }

    @Nullable
    public static <T> T copyProperties(@Nullable Object source, Class<T> targetClazz) throws BeansException {
        if (source == null) {
            return null;
        }
        T to = BeanUtil.newInstance(targetClazz);
        BeanUtil.copyProperties((Object)source, to);
        return to;
    }

    public static <T> List<T> copyProperties(@Nullable Collection<?> sourceList, Class<T> targetClazz) throws BeansException {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> outList = new ArrayList<T>(sourceList.size());
        for (Object source : sourceList) {
            if (source == null) continue;
            T bean = BeanUtil.copyProperties(source, targetClazz);
            outList.add(bean);
        }
        return outList;
    }

    public static Map<String, Object> toMap(@Nullable Object bean) {
        if (bean == null) {
            return new HashMap<String, Object>(0);
        }
        return BladeBeanMap.create(bean);
    }

    public static <T> T toBean(Map<String, Object> beanMap, Class<T> valueType) {
        Objects.requireNonNull(beanMap, "beanMap Could not null");
        T to = BeanUtil.newInstance(valueType);
        if (beanMap.isEmpty()) {
            return to;
        }
        BeanUtil.copy(beanMap, to);
        return to;
    }

    @Nullable
    public static Object generator(@Nullable Object superBean, BeanProperty ... props) {
        if (superBean == null) {
            return null;
        }
        Class<?> superclass = superBean.getClass();
        Object genBean = BeanUtil.generator(superclass, props);
        BeanUtil.copy(superBean, genBean);
        return genBean;
    }

    public static Object generator(Class<?> superclass, BeanProperty ... props) {
        BeanGenerator generator = new BeanGenerator();
        generator.setSuperclass(superclass);
        generator.setUseCache(true);
        for (BeanProperty prop : props) {
            generator.addProperty(prop.getName(), prop.getType());
        }
        return generator.create();
    }
}

