/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.utils;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.springblade.core.tool.utils.Charsets;
import org.springblade.core.tool.utils.DatatypeConverterUtil;
import org.springblade.core.tool.utils.Exceptions;
import org.springframework.lang.Nullable;
import org.springframework.util.DigestUtils;

public class DigestUtil
extends DigestUtils {
    private static final char[] HEX_CODE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String md5Hex(String data) {
        return DigestUtils.md5DigestAsHex((byte[])data.getBytes(Charsets.UTF_8));
    }

    public static String md5Hex(byte[] bytes) {
        return DigestUtils.md5DigestAsHex((byte[])bytes);
    }

    public static String sha1Hex(String data) {
        return DigestUtil.sha1Hex(data.getBytes(Charsets.UTF_8));
    }

    public static String sha1Hex(byte[] bytes) {
        return DigestUtil.digestHex("SHA-1", bytes);
    }

    public static String sha224Hex(String data) {
        return DigestUtil.sha224Hex(data.getBytes(Charsets.UTF_8));
    }

    public static String sha224Hex(byte[] bytes) {
        return DigestUtil.digestHex("SHA-224", bytes);
    }

    public static String sha256Hex(String data) {
        return DigestUtil.sha256Hex(data.getBytes(Charsets.UTF_8));
    }

    public static String sha256Hex(byte[] bytes) {
        return DigestUtil.digestHex("SHA-256", bytes);
    }

    public static String sha384Hex(String data) {
        return DigestUtil.sha384Hex(data.getBytes(Charsets.UTF_8));
    }

    public static String sha384Hex(byte[] bytes) {
        return DigestUtil.digestHex("SHA-384", bytes);
    }

    public static String sha512Hex(String data) {
        return DigestUtil.sha512Hex(data.getBytes(Charsets.UTF_8));
    }

    public static String sha512Hex(byte[] bytes) {
        return DigestUtil.digestHex("SHA-512", bytes);
    }

    public static String digestHex(String algorithm, byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            return DigestUtil.encodeHex(md.digest(bytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String hmacMd5Hex(String data, String key) {
        return DigestUtil.hmacMd5Hex(data.getBytes(Charsets.UTF_8), key);
    }

    public static String hmacMd5Hex(byte[] bytes, String key) {
        return DigestUtil.digestHMacHex("HmacMD5", bytes, key);
    }

    public static String hmacSha1Hex(String data, String key) {
        return DigestUtil.hmacSha1Hex(data.getBytes(Charsets.UTF_8), key);
    }

    public static String hmacSha1Hex(byte[] bytes, String key) {
        return DigestUtil.digestHMacHex("HmacSHA1", bytes, key);
    }

    public static String hmacSha224Hex(String data, String key) {
        return DigestUtil.hmacSha224Hex(data.getBytes(Charsets.UTF_8), key);
    }

    public static String hmacSha224Hex(byte[] bytes, String key) {
        return DigestUtil.digestHMacHex("HmacSHA224", bytes, key);
    }

    public static String hmacSha256Hex(String data, String key) {
        return DigestUtil.hmacSha256Hex(data.getBytes(Charsets.UTF_8), key);
    }

    public static String hmacSha256Hex(byte[] bytes, String key) {
        return DigestUtil.digestHMacHex("HmacSHA256", bytes, key);
    }

    public static String hmacSha384Hex(String data, String key) {
        return DigestUtil.hmacSha384Hex(data.getBytes(Charsets.UTF_8), key);
    }

    public static String hmacSha384Hex(byte[] bytes, String key) {
        return DigestUtil.digestHMacHex("HmacSHA384", bytes, key);
    }

    public static String hmacSha512Hex(String data, String key) {
        return DigestUtil.hmacSha512Hex(data.getBytes(Charsets.UTF_8), key);
    }

    public static String hmacSha512Hex(byte[] bytes, String key) {
        return DigestUtil.digestHMacHex("HmacSHA512", bytes, key);
    }

    public static String digestHMacHex(String algorithm, byte[] bytes, String key) {
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(Charsets.UTF_8), algorithm);
        try {
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            return DigestUtil.encodeHex(mac.doFinal(bytes));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String encodeHex(byte[] bytes) {
        StringBuilder r = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            r.append(HEX_CODE[b >> 4 & 0xF]);
            r.append(HEX_CODE[b & 0xF]);
        }
        return r.toString();
    }

    public static byte[] decodeHex(String hexStr) {
        return DatatypeConverterUtil.parseHexBinary(hexStr);
    }

    public static boolean slowEquals(@Nullable String a, @Nullable String b) {
        if (a == null || b == null) {
            return false;
        }
        return DigestUtil.slowEquals(a.getBytes(Charsets.UTF_8), b.getBytes(Charsets.UTF_8));
    }

    public static boolean slowEquals(@Nullable byte[] a, @Nullable byte[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int diff = a.length ^ b.length;
        for (int i = 0; i < a.length; ++i) {
            diff |= a[i] ^ b[i];
        }
        return diff == 0;
    }

    public static String hex(String data) {
        return DigestUtil.sha1Hex(data);
    }

    public static String encrypt(String data) {
        return DigestUtil.sha1Hex(DigestUtil.md5Hex(data));
    }
}

