/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.springblade.core.tool.jackson.JsonUtil;
import org.springblade.core.tool.utils.Base64Util;
import org.springblade.core.tool.utils.BeanUtil;
import org.springblade.core.tool.utils.Charsets;
import org.springblade.core.tool.utils.ClassUtil;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springblade.core.tool.utils.ConcurrentDateFormat;
import org.springblade.core.tool.utils.ConvertUtil;
import org.springblade.core.tool.utils.DateTimeUtil;
import org.springblade.core.tool.utils.DateUtil;
import org.springblade.core.tool.utils.DigestUtil;
import org.springblade.core.tool.utils.FileUtil;
import org.springblade.core.tool.utils.IoUtil;
import org.springblade.core.tool.utils.NumberUtil;
import org.springblade.core.tool.utils.ObjectUtil;
import org.springblade.core.tool.utils.RandomType;
import org.springblade.core.tool.utils.StringUtil;
import org.springblade.core.tool.utils.UrlUtil;
import org.springframework.beans.BeansException;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;

public class Func {
    public static <T> T requireNotNull(T obj) {
        return Objects.requireNonNull(obj);
    }

    public static <T> T requireNotNull(T obj, String message) {
        return Objects.requireNonNull(obj, message);
    }

    public static <T> T requireNotNull(T obj, Supplier<String> messageSupplier) {
        return Objects.requireNonNull(obj, messageSupplier);
    }

    public static boolean isNull(@Nullable Object obj) {
        return Objects.isNull(obj);
    }

    public static boolean notNull(@Nullable Object obj) {
        return Objects.nonNull(obj);
    }

    public static String firstCharToLower(String str) {
        return StringUtil.firstCharToLower(str);
    }

    public static String firstCharToUpper(String str) {
        return StringUtil.firstCharToUpper(str);
    }

    public static boolean isBlank(@Nullable CharSequence cs) {
        return StringUtil.isBlank(cs);
    }

    public static boolean isNotBlank(@Nullable CharSequence cs) {
        return StringUtil.isNotBlank(cs);
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        return StringUtil.isAnyBlank(css);
    }

    public static boolean isNoneBlank(CharSequence ... css) {
        return StringUtil.isNoneBlank(css);
    }

    public static boolean isArray(@Nullable Object obj) {
        return ObjectUtil.isArray((Object)obj);
    }

    public static boolean isEmpty(@Nullable Object obj) {
        return ObjectUtil.isEmpty((Object)obj);
    }

    public static boolean isNotEmpty(@Nullable Object obj) {
        return !ObjectUtil.isEmpty((Object)obj);
    }

    public static boolean isEmpty(@Nullable Object[] array) {
        return ObjectUtil.isEmpty((Object[])array);
    }

    public static boolean isNotEmpty(@Nullable Object[] array) {
        return ObjectUtil.isNotEmpty(array);
    }

    public static boolean hasEmpty(Object ... os) {
        for (Object o : os) {
            if (!Func.isEmpty(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(Object ... os) {
        for (Object o : os) {
            if (!Func.isNotEmpty(o)) continue;
            return false;
        }
        return true;
    }

    public static String format(@Nullable String message, @Nullable Map<String, Object> params) {
        return StringUtil.format(message, params);
    }

    public static String format(@Nullable String message, Object ... arguments) {
        return StringUtil.format(message, arguments);
    }

    public static boolean equals(Object obj1, Object obj2) {
        return Objects.equals(obj1, obj2);
    }

    public static boolean equalsSafe(@Nullable Object o1, @Nullable Object o2) {
        return ObjectUtil.nullSafeEquals((Object)o1, (Object)o2);
    }

    public static <T> boolean contains(@Nullable T[] array, T element) {
        return CollectionUtil.contains(array, element);
    }

    public static boolean contains(@Nullable Iterator<?> iterator, Object element) {
        return CollectionUtil.contains(iterator, (Object)element);
    }

    public static boolean contains(@Nullable Enumeration<?> enumeration, Object element) {
        return CollectionUtil.contains(enumeration, (Object)element);
    }

    @SafeVarargs
    public static <E> Set<E> ofImmutableSet(E ... es) {
        return CollectionUtil.ofImmutableSet(es);
    }

    @SafeVarargs
    public static <E> List<E> ofImmutableList(E ... es) {
        return CollectionUtil.ofImmutableList(es);
    }

    public static String toStr(Object str) {
        return Func.toStr(str, "");
    }

    public static String toStr(Object str, String defaultValue) {
        if (null == str || str.equals("null")) {
            return defaultValue;
        }
        return String.valueOf(str);
    }

    public static String toStrWithEmpty(Object str, String defaultValue) {
        if (null == str || str.equals("null") || str.equals("")) {
            return defaultValue;
        }
        return String.valueOf(str);
    }

    public static boolean isNumeric(CharSequence cs) {
        return StringUtil.isNumeric(cs);
    }

    public static int toInt(Object str) {
        return NumberUtil.toInt(str);
    }

    public static int toInt(@Nullable Object str, int defaultValue) {
        return NumberUtil.toInt(str, defaultValue);
    }

    public static long toLong(Object str) {
        return NumberUtil.toLong(str);
    }

    public static long toLong(@Nullable Object str, long defaultValue) {
        return NumberUtil.toLong(str, defaultValue);
    }

    public static Double toDouble(Object value) {
        return Func.toDouble(value, -1.0);
    }

    public static Double toDouble(Object value, Double defaultValue) {
        return NumberUtil.toDouble(value, defaultValue);
    }

    public static Float toFloat(Object value) {
        return Func.toFloat(value, Float.valueOf(-1.0f));
    }

    public static Float toFloat(Object value, Float defaultValue) {
        return NumberUtil.toFloat(value, defaultValue);
    }

    public static Boolean toBoolean(Object value) {
        return Func.toBoolean(value, null);
    }

    public static Boolean toBoolean(Object value, Boolean defaultValue) {
        if (value != null) {
            String val = String.valueOf(value);
            val = val.toLowerCase().trim();
            return Boolean.parseBoolean(val);
        }
        return defaultValue;
    }

    public static Integer[] toIntArray(String str) {
        return Func.toIntArray(",", str);
    }

    public static Integer[] toIntArray(String split, String str) {
        if (StringUtil.isEmpty((Object)str)) {
            return new Integer[0];
        }
        String[] arr = Func.split(str, split);
        Integer[] ints = new Integer[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            Integer v;
            ints[i] = v = Integer.valueOf(Func.toInt(arr[i], 0));
        }
        return ints;
    }

    public static List<Integer> toIntList(String str) {
        return Arrays.asList(Func.toIntArray(str));
    }

    public static List<Integer> toIntList(String split, String str) {
        return Arrays.asList(Func.toIntArray(split, str));
    }

    public static Integer firstInt(String str) {
        return Func.firstInt(",", str);
    }

    public static Integer firstInt(String split, String str) {
        List<Integer> ints = Func.toIntList(split, str);
        if (Func.isEmpty(ints)) {
            return null;
        }
        return ints.get(0);
    }

    public static Long[] toLongArray(String str) {
        return Func.toLongArray(",", str);
    }

    public static Long[] toLongArray(String split, String str) {
        if (StringUtil.isEmpty((Object)str)) {
            return new Long[0];
        }
        String[] arr = Func.split(str, split);
        Long[] longs = new Long[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            Long v;
            longs[i] = v = Long.valueOf(Func.toLong(arr[i], 0L));
        }
        return longs;
    }

    public static List<Long> toLongList(String str) {
        return Arrays.asList(Func.toLongArray(str));
    }

    public static List<Long> toLongList(String split, String str) {
        return Arrays.asList(Func.toLongArray(split, str));
    }

    public static Long firstLong(String str) {
        return Func.firstLong(",", str);
    }

    public static Long firstLong(String split, String str) {
        List<Long> longs = Func.toLongList(split, str);
        if (Func.isEmpty(longs)) {
            return null;
        }
        return longs.get(0);
    }

    public static String[] toStrArray(String str) {
        return Func.toStrArray(",", str);
    }

    public static String[] toStrArray(String split, String str) {
        if (Func.isBlank(str)) {
            return new String[0];
        }
        return Func.split(str, split);
    }

    public static List<String> toStrList(String str) {
        return Arrays.asList(Func.toStrArray(str));
    }

    public static List<String> toStrList(String split, String str) {
        return Arrays.asList(Func.toStrArray(split, str));
    }

    public static String firstStr(String str) {
        return Func.firstStr(",", str);
    }

    public static String firstStr(String split, String str) {
        List<String> strs = Func.toStrList(split, str);
        if (Func.isEmpty(strs)) {
            return null;
        }
        return strs.get(0);
    }

    public static String to62String(long num) {
        return NumberUtil.to62String(num);
    }

    public static String join(Collection<?> coll) {
        return StringUtil.join(coll);
    }

    public static String join(Collection<?> coll, String delim) {
        return StringUtil.join(coll, delim);
    }

    public static String join(Object[] arr) {
        return StringUtil.join(arr);
    }

    public static String join(Object[] arr, String delim) {
        return StringUtil.join(arr, delim);
    }

    public static List<String> split(CharSequence str, char separator) {
        return StringUtil.split(str, separator, -1);
    }

    public static List<String> splitTrim(CharSequence str, char separator) {
        return StringUtil.splitTrim(str, separator);
    }

    public static List<String> splitTrim(CharSequence str, CharSequence separator) {
        return StringUtil.splitTrim(str, separator);
    }

    public static String[] split(@Nullable String str, @Nullable String delimiter) {
        return StringUtil.delimitedListToStringArray((String)str, (String)delimiter);
    }

    public static String[] splitTrim(@Nullable String str, @Nullable String delimiter) {
        return StringUtil.delimitedListToStringArray((String)str, (String)delimiter, (String)" \t\n\n\f");
    }

    public static boolean simpleMatch(@Nullable String pattern, @Nullable String str) {
        return PatternMatchUtils.simpleMatch((String)pattern, (String)str);
    }

    public static boolean simpleMatch(@Nullable String[] patterns, String str) {
        return PatternMatchUtils.simpleMatch((String[])patterns, (String)str);
    }

    public static String randomUUID() {
        return StringUtil.randomUUID();
    }

    public static String escapeHtml(String html) {
        return StringUtil.escapeHtml(html);
    }

    public static String random(int count) {
        return StringUtil.random(count);
    }

    public static String random(int count, RandomType randomType) {
        return StringUtil.random(count, randomType);
    }

    public static String md5Hex(String data) {
        return DigestUtil.md5Hex(data);
    }

    public static String md5Hex(byte[] bytes) {
        return DigestUtil.md5Hex(bytes);
    }

    public static String sha1Hex(String data) {
        return DigestUtil.sha1Hex(data);
    }

    public static String sha1Hex(byte[] bytes) {
        return DigestUtil.sha1Hex(bytes);
    }

    public static String sha224Hex(String data) {
        return DigestUtil.sha224Hex(data);
    }

    public static String sha224Hex(byte[] bytes) {
        return DigestUtil.sha224Hex(bytes);
    }

    public static String sha256Hex(String data) {
        return DigestUtil.sha256Hex(data);
    }

    public static String sha256Hex(byte[] bytes) {
        return DigestUtil.sha256Hex(bytes);
    }

    public static String sha384Hex(String data) {
        return DigestUtil.sha384Hex(data);
    }

    public static String sha384Hex(byte[] bytes) {
        return DigestUtil.sha384Hex(bytes);
    }

    public static String sha512Hex(String data) {
        return DigestUtil.sha512Hex(data);
    }

    public static String sha512Hex(byte[] bytes) {
        return DigestUtil.sha512Hex(bytes);
    }

    public static String hmacMd5Hex(String data, String key) {
        return DigestUtil.hmacMd5Hex(data, key);
    }

    public static String hmacMd5Hex(byte[] bytes, String key) {
        return DigestUtil.hmacMd5Hex(bytes, key);
    }

    public static String hmacSha1Hex(String data, String key) {
        return DigestUtil.hmacSha1Hex(data, key);
    }

    public static String hmacSha1Hex(byte[] bytes, String key) {
        return DigestUtil.hmacSha1Hex(bytes, key);
    }

    public static String hmacSha224Hex(String data, String key) {
        return DigestUtil.hmacSha224Hex(data, key);
    }

    public static String hmacSha224Hex(byte[] bytes, String key) {
        return DigestUtil.hmacSha224Hex(bytes, key);
    }

    public static String hmacSha256Hex(String data, String key) {
        return DigestUtil.hmacSha256Hex(data, key);
    }

    public static String hmacSha256Hex(byte[] bytes, String key) {
        return DigestUtil.hmacSha256Hex(bytes, key);
    }

    public static String hmacSha384Hex(String data, String key) {
        return DigestUtil.hmacSha384Hex(data, key);
    }

    public static String hmacSha384Hex(byte[] bytes, String key) {
        return DigestUtil.hmacSha384Hex(bytes, key);
    }

    public static String hmacSha512Hex(String data, String key) {
        return DigestUtil.hmacSha512Hex(data, key);
    }

    public static String hmacSha512Hex(byte[] bytes, String key) {
        return DigestUtil.hmacSha512Hex(bytes, key);
    }

    public static String encodeHex(byte[] bytes) {
        return DigestUtil.encodeHex(bytes);
    }

    public static byte[] decodeHex(String hexString) {
        return DigestUtil.decodeHex(hexString);
    }

    public static String encodeBase64(String value) {
        return Base64Util.encode(value);
    }

    public static String encodeBase64(String value, Charset charset) {
        return Base64Util.encode(value, charset);
    }

    public static String encodeBase64UrlSafe(String value) {
        return Base64Util.encodeUrlSafe(value);
    }

    public static String encodeBase64UrlSafe(String value, Charset charset) {
        return Base64Util.encodeUrlSafe(value, charset);
    }

    public static String decodeBase64(String value) {
        return Base64Util.decode(value);
    }

    public static String decodeBase64(String value, Charset charset) {
        return Base64Util.decode(value, charset);
    }

    public static String decodeBase64UrlSafe(String value) {
        return Base64Util.decodeUrlSafe(value);
    }

    public static String decodeBase64UrlSafe(String value, Charset charset) {
        return Base64Util.decodeUrlSafe(value, charset);
    }

    public static void closeQuietly(@Nullable Closeable closeable) {
        IoUtil.closeQuietly(closeable);
    }

    public static String readToString(InputStream input) {
        return IoUtil.readToString(input);
    }

    public static String readToString(@Nullable InputStream input, Charset charset) {
        return IoUtil.readToString(input, charset);
    }

    public static byte[] readToByteArray(@Nullable InputStream input) {
        return IoUtil.readToByteArray(input);
    }

    public static String readToString(File file) {
        return FileUtil.readToString(file);
    }

    public static String readToString(File file, Charset encoding) {
        return FileUtil.readToString(file, encoding);
    }

    public static byte[] readToByteArray(File file) {
        return FileUtil.readToByteArray(file);
    }

    public static String toJson(Object object) {
        return JsonUtil.toJson(object);
    }

    public static byte[] toJsonAsBytes(Object object) {
        return JsonUtil.toJsonAsBytes(object);
    }

    public static JsonNode readTree(String jsonString) {
        return JsonUtil.readTree(jsonString);
    }

    public static JsonNode readTree(InputStream in) {
        return JsonUtil.readTree(in);
    }

    public static JsonNode readTree(byte[] content) {
        return JsonUtil.readTree(content);
    }

    public static JsonNode readTree(JsonParser jsonParser) {
        return JsonUtil.readTree(jsonParser);
    }

    public static <T> T readJson(byte[] bytes, Class<T> valueType) {
        return JsonUtil.parse(bytes, valueType);
    }

    public static <T> T readJson(String jsonString, Class<T> valueType) {
        return JsonUtil.parse(jsonString, valueType);
    }

    public static <T> T readJson(InputStream in, Class<T> valueType) {
        return JsonUtil.parse(in, valueType);
    }

    public static <T> T readJson(byte[] bytes, TypeReference<T> typeReference) {
        return JsonUtil.parse(bytes, typeReference);
    }

    public static <T> T readJson(String jsonString, TypeReference<T> typeReference) {
        return JsonUtil.parse(jsonString, typeReference);
    }

    public static <T> T readJson(InputStream in, TypeReference<T> typeReference) {
        return JsonUtil.parse(in, typeReference);
    }

    public static String urlEncode(String source) {
        return UrlUtil.encode((String)source, (Charset)Charsets.UTF_8);
    }

    public static String urlEncode(String source, Charset charset) {
        return UrlUtil.encode((String)source, (Charset)charset);
    }

    public static String urlDecode(String source) {
        return StringUtils.uriDecode((String)source, (Charset)Charsets.UTF_8);
    }

    public static String urlDecode(String source, Charset charset) {
        return StringUtils.uriDecode((String)source, (Charset)charset);
    }

    public static String formatDateTime(Date date) {
        return DateUtil.formatDateTime(date);
    }

    public static String formatDate(Date date) {
        return DateUtil.formatDate(date);
    }

    public static String formatTime(Date date) {
        return DateUtil.formatTime(date);
    }

    public static String format(Object object, String pattern) {
        if (object instanceof Number) {
            DecimalFormat decimalFormat = new DecimalFormat(pattern);
            return decimalFormat.format(object);
        }
        if (object instanceof Date) {
            return DateUtil.format((Date)object, pattern);
        }
        if (object instanceof TemporalAccessor) {
            return DateTimeUtil.format((TemporalAccessor)object, pattern);
        }
        throw new IllegalArgumentException("\u672a\u652f\u6301\u7684\u5bf9\u8c61:" + object + ",\u683c\u5f0f:" + object);
    }

    public static Date parseDate(String dateStr, String pattern) {
        return DateUtil.parse(dateStr, pattern);
    }

    public static Date parse(String dateStr, ConcurrentDateFormat format) {
        return DateUtil.parse(dateStr, format);
    }

    public static String formatDateTime(TemporalAccessor temporal) {
        return DateTimeUtil.formatDateTime(temporal);
    }

    public static String formatDate(TemporalAccessor temporal) {
        return DateTimeUtil.formatDate(temporal);
    }

    public static String formatTime(TemporalAccessor temporal) {
        return DateTimeUtil.formatTime(temporal);
    }

    public static LocalDateTime parseDateTime(String dateStr, DateTimeFormatter formatter) {
        return DateTimeUtil.parseDateTime(dateStr, formatter);
    }

    public static LocalDateTime parseDateTime(String dateStr) {
        return DateTimeUtil.parseDateTime(dateStr);
    }

    public static LocalDate parseDate(String dateStr, DateTimeFormatter formatter) {
        return DateTimeUtil.parseDate(dateStr, formatter);
    }

    public static LocalDate parseDate(String dateStr) {
        return DateTimeUtil.parseDate(dateStr, DateTimeUtil.DATE_FORMAT);
    }

    public static LocalTime parseTime(String dateStr, DateTimeFormatter formatter) {
        return DateTimeUtil.parseTime(dateStr, formatter);
    }

    public static LocalTime parseTime(String dateStr) {
        return DateTimeUtil.parseTime(dateStr);
    }

    public static Duration between(Temporal startInclusive, Temporal endExclusive) {
        return Duration.between(startInclusive, endExclusive);
    }

    public static Duration between(Date startDate, Date endDate) {
        return DateUtil.between(startDate, endDate);
    }

    @Nullable
    public static <T> T convert(@Nullable Object source, Class<T> targetType) {
        return ConvertUtil.convert(source, targetType);
    }

    @Nullable
    public static <T> T convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return ConvertUtil.convert(source, sourceType, targetType);
    }

    @Nullable
    public static <T> T convert(@Nullable Object source, TypeDescriptor targetType) {
        return ConvertUtil.convert(source, targetType);
    }

    public static MethodParameter getMethodParameter(Constructor<?> constructor, int parameterIndex) {
        return ClassUtil.getMethodParameter(constructor, parameterIndex);
    }

    public static MethodParameter getMethodParameter(Method method, int parameterIndex) {
        return ClassUtil.getMethodParameter(method, parameterIndex);
    }

    @Nullable
    public static <A extends Annotation> A getAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
        return (A)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)annotatedElement, annotationType);
    }

    @Nullable
    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationType) {
        return ClassUtil.getAnnotation(method, annotationType);
    }

    @Nullable
    public static <A extends Annotation> A getAnnotation(HandlerMethod handlerMethod, Class<A> annotationType) {
        return ClassUtil.getAnnotation(handlerMethod, annotationType);
    }

    public static <T> T newInstance(Class<?> clazz) {
        return (T)BeanUtil.instantiateClass(clazz);
    }

    public static <T> T newInstance(String clazzStr) {
        return BeanUtil.newInstance(clazzStr);
    }

    @Nullable
    public static Object getProperty(@Nullable Object bean, String propertyName) {
        return BeanUtil.getProperty(bean, propertyName);
    }

    public static void setProperty(Object bean, String propertyName, Object value) {
        BeanUtil.setProperty(bean, propertyName, value);
    }

    @Nullable
    public static <T> T clone(@Nullable T source) {
        return BeanUtil.clone(source);
    }

    @Nullable
    public static <T> T copy(@Nullable Object source, Class<T> clazz) {
        return BeanUtil.copy(source, clazz);
    }

    public static void copy(@Nullable Object source, @Nullable Object targetBean) {
        BeanUtil.copy(source, targetBean);
    }

    public static void copyNonNull(@Nullable Object source, @Nullable Object targetBean) {
        BeanUtil.copyNonNull(source, targetBean);
    }

    @Nullable
    public static <T> T copyWithConvert(@Nullable Object source, Class<T> clazz) {
        return BeanUtil.copyWithConvert(source, clazz);
    }

    public static <T> List<T> copy(@Nullable Collection<?> sourceList, Class<T> targetClazz) {
        return BeanUtil.copy(sourceList, targetClazz);
    }

    public static <T> List<T> copyWithConvert(@Nullable Collection<?> sourceList, Class<T> targetClazz) {
        return BeanUtil.copyWithConvert(sourceList, targetClazz);
    }

    @Nullable
    public static <T> T copyProperties(@Nullable Object source, Class<T> clazz) throws BeansException {
        return BeanUtil.copyProperties(source, clazz);
    }

    public static <T> List<T> copyProperties(@Nullable Collection<?> sourceList, Class<T> targetClazz) throws BeansException {
        return BeanUtil.copyProperties(sourceList, targetClazz);
    }

    public static Map<String, Object> toMap(@Nullable Object bean) {
        return BeanUtil.toMap(bean);
    }

    public static <T> T toBean(Map<String, Object> beanMap, Class<T> valueType) {
        return BeanUtil.toBean(beanMap, valueType);
    }
}

