/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.utils;

import org.springframework.lang.Nullable;
import org.springframework.util.NumberUtils;

public class NumberUtil
extends NumberUtils {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static int toInt(Object str) {
        return NumberUtil.toInt(str, -1);
    }

    public static int toInt(@Nullable Object str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(String.valueOf(str));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static long toLong(Object str) {
        return NumberUtil.toLong(str, 0L);
    }

    public static long toLong(@Nullable Object str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.valueOf(String.valueOf(str));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static Double toDouble(Object value) {
        return NumberUtil.toDouble(value, null);
    }

    public static Double toDouble(@Nullable Object value, Double defaultValue) {
        if (value != null) {
            return Double.valueOf(String.valueOf(value).trim());
        }
        return defaultValue;
    }

    public static Float toFloat(Object value) {
        return NumberUtil.toFloat(value, null);
    }

    public static Float toFloat(@Nullable Object value, Float defaultValue) {
        if (value != null) {
            return Float.valueOf(String.valueOf(value).trim());
        }
        return defaultValue;
    }

    public static String to62String(long i) {
        int radix = DIGITS.length;
        char[] buf = new char[65];
        int charPos = 64;
        for (i = -i; i <= (long)(-radix); i /= (long)radix) {
            buf[charPos--] = DIGITS[(int)(-(i % (long)radix))];
        }
        buf[charPos] = DIGITS[(int)(-i)];
        return new String(buf, charPos, 65 - charPos);
    }
}

