/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.utils;

import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.List;
import org.springblade.core.tool.utils.NumberUtil;
import org.springblade.core.tool.utils.StringUtil;

public class RuntimeUtil {
    public static int getPid() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index > 0) {
            return NumberUtil.toInt(jvmName.substring(0, index), -1);
        }
        return -1;
    }

    public static Duration getUpTime() {
        long upTime = ManagementFactory.getRuntimeMXBean().getUptime();
        return Duration.ofMillis(upTime);
    }

    public static String getJvmArguments() {
        List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        return StringUtil.join(vmArguments, " ");
    }

    public static int getCpuNum() {
        return Runtime.getRuntime().availableProcessors();
    }
}

