/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.yml;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.springblade.core.tool.utils.StringUtil;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.DefaultPropertySourceFactory;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.lang.Nullable;

public class YmlPropertyLoaderFactory
extends DefaultPropertySourceFactory {
    public PropertySource<?> createPropertySource(@Nullable String name, EncodedResource encodedResource) throws IOException {
        if (encodedResource == null) {
            return YmlPropertyLoaderFactory.emptyPropertySource(name);
        }
        Resource resource = encodedResource.getResource();
        String fileName = resource.getFilename();
        List sources = new YamlPropertySourceLoader().load(fileName, resource);
        if (sources.isEmpty()) {
            return YmlPropertyLoaderFactory.emptyPropertySource(fileName);
        }
        HashMap ymlDataMap = new HashMap(32);
        for (PropertySource source : sources) {
            ymlDataMap.putAll((Map)((MapPropertySource)source).getSource());
        }
        return new OriginTrackedMapPropertySource(YmlPropertyLoaderFactory.getSourceName(fileName, name), ymlDataMap);
    }

    private static PropertySource<?> emptyPropertySource(@Nullable String name) {
        return new MapPropertySource(YmlPropertyLoaderFactory.getSourceName(name), Collections.emptyMap());
    }

    private static String getSourceName(String ... names) {
        return Stream.of(names).filter(StringUtil::isNotBlank).findFirst().orElse("BladeYmlPropertySource");
    }
}

