/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.config;

import org.springblade.core.tool.redis.RedisKeySerializer;
import org.springblade.core.tool.utils.RedisUtil;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

@EnableCaching
@AutoConfiguration
@AutoConfigureBefore(value={RedisAutoConfiguration.class})
public class RedisConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={RedisSerializer.class})
    public RedisSerializer<Object> redisSerializer() {
        return new JdkSerializationRedisSerializer();
    }

    @Bean(name={"redisTemplate"})
    @ConditionalOnMissingBean(value={RedisTemplate.class})
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory, RedisSerializer<Object> redisSerializer) {
        RedisTemplate redisTemplate = new RedisTemplate();
        RedisKeySerializer redisKeySerializer = new RedisKeySerializer();
        redisTemplate.setKeySerializer((RedisSerializer)redisKeySerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)redisKeySerializer);
        redisTemplate.setValueSerializer(redisSerializer);
        redisTemplate.setHashValueSerializer(redisSerializer);
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        return redisTemplate;
    }

    @Bean(name={"redisUtil"})
    @ConditionalOnBean(value={RedisTemplate.class})
    public RedisUtil redisUtils(RedisTemplate<String, Object> redisTemplate) {
        return new RedisUtil(redisTemplate);
    }
}

